/*
    kjofol_prefs.h

    Copyright (c) 2004-2005 by Stefan Gehn             <metz AT gehn DOT net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KJOFOL_PREFS_H
#define KJOFOL_PREFS_H

#include "noatun/cmodule.h"
#include <qpixmap.h>

#include <kio/job.h>

class KJSkinselector;
class KJGuiSettings;
namespace Noatun
{
	class Plugin;
}

/**
 * @author Stefan Gehn
 */
class KJPrefs : public Noatun::PreferencesPage
{
Q_OBJECT
	public:
		KJPrefs(Noatun::Plugin *plug);

	public Q_SLOTS:
		virtual void defaults();
		virtual void save();
		virtual void load();

	private Q_SLOTS:
		// Installs a skin defined by the URL in mSkinRequester
		void installNewSkin();
		// Delete the currently selected Skin (does not work for systemwide skins!)
		void removeSelectedSkin();
		// Show a preview of "skin" in mPixmap
		void showPreview(const QString &skin);
		// gets called after a KIO-action has finished
		// KIO is used for installing/removing skins
		void slotResult(KJob *job);
		void slotSkinChanged(const QString&);

	private:
		QString expand(const QString &s);
		void loadInternal();

	private:
		QPixmap mPixmap; /// Preview Pixmap
		/// Dialog-Widgets
		KJSkinselector *mSkinselectorWidget;
		KJGuiSettings *mGuiSettingsWidget;
};

#endif // KJOFOL_PREFS_H
