#ifndef TAGSGET_H
#define TAGSGET_H

#include "noatun/cmodule.h"
#include "tags.h"

#include <qlist.h>

class QCheckBox;
class QSlider;
class QSpinBox;

namespace Noatun
{

class TagsGetter : public QObject, public PlaylistNotifier
{
Q_OBJECT
public:
	explicit TagsGetter(Global *global);

	void associate(Tags *t);
	// if returns true, I'm deleted
	bool unassociate(Tags *t);

	int interval() const;
	bool loadAuto() const;

public: //Reimplemented from PlaylistNotifier
	virtual void added(PlaylistItem &);
	virtual void removed(PlaylistItem &);

protected:
	void timerEvent(QTimerEvent *);

public Q_SLOTS:
	void setInterval(int ms);
	void setLoadAuto(bool);

private Q_SLOTS:
	// select the songs that need updating
	void getSongs();
	void newSong();

private:
	void sortPriority();
	static bool lowerPrio(Tags* t1, Tags* t2);

private:
	QList<Tags*> tags;
	QList<PlaylistItem> items;
	int mTimerID;
};


class TagsPreferencesPage : public PreferencesPage
{
Q_OBJECT
public:
	explicit TagsPreferencesPage(TagsGetter* parent);

public Q_SLOTS:
	virtual void save();
	virtual void load();
	virtual void defaults();

private:
	QCheckBox *onPlay;
	QSlider *slider;
	QSpinBox *spin;
	TagsGetter *tagsgetter;
};

}


#endif

