/* This file is part of Noatun

  Copyright 2000-2006 by Charles Samuels <charles@kde.org>
  Copyright 2000-2002 by Neil Stevens <neil@qualityassistant.com>
  Copyright 2000-2001 by Nikolas Zimmermann <wildfox@kde.org>
  Copyright 2003-2007 by Stefan Gehn <mETz81@web.de>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef N_PLUGINLOADER_H
#define N_PLUGINLOADER_H

#include <QtCore/QStringList>
#include <QtCore/QObject>
#include <noatun/noatun_export.h>
#include <kplugininfo.h>

namespace Noatun
{

class Plugin;
class Global;

typedef QList<Plugin *> PluginList;
typedef QList<KPluginInfo> PluginInfoList;

/**
 * Used for loading plugins at runtime
 **/
class NOATUN_EXPORT PluginHandler : public QObject
{
	Q_OBJECT
public:
	explicit PluginHandler(Global *parent);
	~PluginHandler();

	PluginInfoList availablePlugins(const QString &category = QString()) const;
	PluginInfoList availablePluginsByInterface(const QString &interface) const;

	PluginList loadedPlugins(const QString &category = QString()) const;
	PluginList loadedPluginsByInterface(const QString &interface) const;

	KPluginInfo pluginInfo(const Plugin *plugin) const;
	KPluginInfo pluginInfoFromName(const QString &pluginName) const;
	Plugin* plugin(const QString &pluginName) const;
	const QStringList pluginInterfaces(const KPluginInfo &info) const;
	const QStringList pluginInterfaces(const Plugin *plugin) const;

	bool loadAll();
	bool loadPlugin(const QStringList &modules);
	void unloadAll();
	void loadPlugin(const QString &pluginName);
	bool unloadPlugin(const QStringList &pluginList);
	bool unloadPlugin(const QString &pluginName);
	/**
	 * Save list of current plugin status (i.e. loaded or not)
	 */
	void savePluginStatus();

private Q_SLOTS:
	void slotReadyForUnload(Plugin *plugin);
	void slotLoadScheduledPlugin();
#if 0
	// This happily breaks with messageboxes shown while unloading a plugin
	// because the timer will continue when the messagebox is shown!
	void slotUnloadTimeout();
#endif
	void slotUnloadAllFinished();
	void slotPluginDestroyed(QObject *plugin);

Q_SIGNALS:
	void pluginUnloaded(Plugin *);
	void pluginLoaded(Plugin *);
	void allPluginsUnloaded();
	void allPluginsLoaded();

private:
	Plugin *loadPluginInternal(const QString &pluginName);
	void loadAutomatic(QStringList &thelist, const QString &type);

private:
	class Private;
	Private * const d;
};

} // namespace Noatun

#endif // N_PLUGINLOADER_H
