/* This file is part of Noatun

  Copyright 2005-2007 by Stefan Gehn <mETz81@web.de>
  Copyright 2006 by Charles Samuels <charles@kde.org>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "noatun/nmainwindow.h"
#include "noatun/plugin.h"
#include "noatun/global.h"
#include "noatun/pluginloader.h"
#include "noatun/stdaction.h"

#include <qlist.h>
#include <qevent.h>

#include <kapplication.h>
#include <kdebug.h>
#include <kmenubar.h>
#include <kstandarddirs.h>
#include <kstatusbar.h>
#include <ktoolbar.h>
#include <kxmlguiclient.h>

namespace Noatun
{

class NMainWindowPrivate
{
public:
	bool    bMergedNoatunXML;
	bool    bIsSkinned;
	bool    bWantMerge;
	Plugin *plugin;
};


// -----------------------------------------------------------------------------


NMainWindow::NMainWindow(Plugin *plug, bool isSkinned, bool wantNoatunXML, QWidget* parent, Qt::WindowFlags f)
	: KXmlGuiWindow(parent, f), d(new NMainWindowPrivate)
{
	//TODO: Should this decision be up to the plugins using NMainWindow?
	setAttribute(Qt::WA_DeleteOnClose, false);
	setComponentData(plug->componentData());

	kDebug(66666) << "for plugin '"
		<< plug->componentData().componentName() << "'" << endl;

	d->bMergedNoatunXML = false;
	d->bWantMerge       = wantNoatunXML;
	d->bIsSkinned       = isSkinned;
	d->plugin           = plug;
	updateSkin();
}


NMainWindow::~NMainWindow()
{
	delete d;
}


void NMainWindow::setXMLFile(const QString &file, bool merge, bool setXMLDoc)
{
	kDebug(66666) <<
		"file = " << file << ", merge = " << merge <<
		", setXMLDoc = " << setXMLDoc <<
		";  bMergedNoatunXML = " << d->bMergedNoatunXML << endl;

	// called like this for the kde global rc file, assume our noatun.rc contents are lost
	if (!merge)
	{
		d->bMergedNoatunXML = false;
	}

	if (merge || file.isNull())
	{
		if (d->bWantMerge && !d->bMergedNoatunXML)
		{
			kDebug(66666) <<
				"MERGING IN " << KStandardDirs::locate("data", "noatun/noatun.rc") << endl;

			KXMLGUIClient::setXMLFile("noatun/noatun.rc", true);
			d->bMergedNoatunXML = true;
		}
	}
	if (!file.isNull())
		KXMLGUIClient::setXMLFile(file, merge, setXMLDoc);
}


void NMainWindow::setupGUI(StandardWindowOptions options, const QString &xmlfile)
{
	kDebug(66666) <<
		"BEGIN; options = " << options << ", xmlfile = '" << xmlfile << "'" << endl;

	KXmlGuiWindow::setupGUI(options, xmlfile);
	updateSkin();

	kDebug(66666) << "END";
}


void NMainWindow::updateSkin()
{
	// Skinned Windows need no menubar or toolbars
	if (d->bIsSkinned)
	{
		/*kDebug(66666) <<
			"Window is skinned, hiding GUI items" << endl;*/

		setHelpMenuEnabled(false);
		setUpdatesEnabled(false);
		{
			foreach(KToolBar *tb, toolBars())
				tb->hide();

			menuBar()->hide();
			statusBar()->hide();

			//TODO: hide dockwidgets
			/*leftDock()->hide();
			rightDock()->hide();
			topDock()->hide();
			bottomDock()->hide();*/
		}
		setUpdatesEnabled(true);
	}
}


void NMainWindow::closeEvent(QCloseEvent *e)
{
	if (d->plugin->global()->pluginHandler()->plugin("noatun_systray"))
	{
		kDebug(66666) << "systray loaded";
		if (settingsDirty() && autoSaveSettings())
			saveAutoSaveSettings();
		if (queryClose())
			e->accept();
	}
	else
		KXmlGuiWindow::closeEvent(e);
}


bool NMainWindow::queryClose()
{
	return true;
}


} // namespace Noatun
#include "nmainwindow.moc"
