/* This file is part of Noatun

  Copyright 2005-2006 by Charles Samuels <charles@kde.org>
  Copyright 2005-2007 by Stefan Gehn <mETz81@web.de>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include <noatun/frontend.h>
#include <noatun/global.h>
#include <noatun/plugin.h>
#include <noatun/pluginloader.h>
#include <noatun/plugininterfaces.h>

#include <qevent.h>
#include <qtimer.h>

#include <kdebug.h>

namespace Noatun
{

Frontend::Frontend(Global *parent)
	: QObject(parent), mPlugin(0), mIface(0)
{
	setObjectName("Noatun_Frontend");
	kDebug(66666) ;
	connect(
			parent->pluginHandler(), SIGNAL(pluginLoaded(Plugin *)),
			this, SLOT(slotPluginLoaded(Plugin *))
		);

	connect(
			parent->pluginHandler(), SIGNAL(pluginUnloaded(Plugin *)),
			this, SLOT(slotPluginUnloaded(Plugin *))
		);
}

Frontend::~Frontend()
{
	kDebug(66666) ;
}

void Frontend::slotPluginLoaded(Plugin *plug)
{
	if (FrontendInterface *f = plug->interface<FrontendInterface>())
	{
		kDebug(66666) << "New Plugin is a userinterface";
		// Only one UI at a time please, unload the old one now
		if (mPlugin)
		{
			kDebug(66666) << "Unloading old userinterface...";
			mPlugin->requestUnload();
		}
		mPlugin = plug;
		mIface = f;
		mIface->mainWindow()->installEventFilter(this);
		emit newFrontend();
	}
}

void Frontend::slotPluginUnloaded(Plugin *plug)
{
	if (FrontendInterface *f = plug->interface<FrontendInterface>())
	{
		if (plug == mPlugin && f == mIface)
		{
			kDebug(66666) << "Userinterface unloaded!";
			mPlugin = 0;
			mIface = 0;
			emit newFrontend();
		}
	}
}

KXmlGuiWindow *Frontend::mainWindow()
{
	if (mIface)
		return mIface->mainWindow();
	return 0;
}

bool Frontend::eventFilter(QObject *o, QEvent *e)
{
	if (mIface && (e->type() == QEvent::Close) && (o == mIface->mainWindow()))
	{
		kDebug(66666) << "QEvent::Close for frontend window seen";

		Global *glob = static_cast<Global *>(parent());

		if (glob->pluginHandler()->plugin("noatun_systray") == 0L)
			QTimer::singleShot(0, glob, SLOT(quit()));
		else
			mainWindow()->hide();

		return true;
	}
	return false;
}

} // namespace Noatun
#include "frontend.moc"
