/* This file is part of Noatun

  Copyright 2005-2007 by Stefan Gehn <mETz81@web.de>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "generalprefs.h"
#include "ui_generalprefswidget.h"

#include "noatun/global.h"
#include "noatun/pluginloader.h"
#include "noatun/config.h"

#include <klocale.h>
#include <kdebug.h>
#include <kurlrequester.h>

#include <kicon.h>

using namespace Noatun;


GeneralPrefsPage::GeneralPrefsPage(Global *nInst)
	: PreferencesPage(new QWidget(), i18n("General")), nInstance(nInst),
	w(new Ui::GeneralPrefsWidget())
{
	setHeader(i18n("General Options"));
	setIcon(KIcon("configure"));

	w->setupUi(widget());
	// TODO mixer selection for hardware volume-control
	w->urlMixerDevice->setEnabled(false);
	w->urlDownloadPath->setMode(KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly);

	connect(w->mOneInstance, SIGNAL(toggled(bool)), SLOT(changed()));
	connect(w->mClearOnOpen, SIGNAL(toggled(bool)), SLOT(changed()));
	connect(w->txtTitleFormat, SIGNAL(textChanged(const QString &)), SLOT(changed()));
	connect(w->urlDownloadPath, SIGNAL(textChanged(const QString &)), SLOT(changed()));
}


void GeneralPrefsPage::defaults()
{
	kDebug(66666) ;
	nInstance->config()->setDefaults();
	loadInternal();
	emit changed(true);
}


void GeneralPrefsPage::load()
{
	kDebug(66666) ;
	nInstance->config()->readConfig();
	loadInternal();
	emit changed(false);
}


void GeneralPrefsPage::save()
{
	kDebug(66666) ;
	Noatun::Config *c = nInstance->config();

	c->setOneInstance(w->mOneInstance->isChecked());
	c->setClearOnOpen(w->mClearOnOpen->isChecked());
	c->setDownloadPath(w->urlDownloadPath->url().path());
	c->setTitleFormat(w->txtTitleFormat->text());
	c->writeConfig();

	emit changed(false);
}


void GeneralPrefsPage::loadInternal()
{
	const Noatun::Config *c = nInstance->config();
	w->mOneInstance->setChecked(c->oneInstance());
	w->mClearOnOpen->setChecked(c->clearOnOpen());
	w->urlDownloadPath->setUrl(c->downloadPath());
	w->txtTitleFormat->setText(c->titleFormat());
}

#include "generalprefs.moc"
