/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */
#ifndef Phonon_NMM_VIDEOPATH_H
#define Phonon_NMM_VIDEOPATH_H

#include <QObject>
#include <QList>
namespace NMM
{
    class GraphHandler;
    class INode;
}

namespace Phonon
{
namespace nmm
{
	class VideoEffect;
	class AbstractVideoOutput;

	class VideoPath : public QObject
	{
		Q_OBJECT
		public:
			VideoPath( QObject* parent );
			~VideoPath();

			// Operations:
			Q_INVOKABLE bool addOutput( QObject* videoOutput );
			Q_INVOKABLE bool removeOutput( QObject* videoOutput );
			Q_INVOKABLE bool insertEffect( QObject* newEffect, QObject* insertBefore = 0 );
			Q_INVOKABLE bool removeEffect( QObject* effect );

			//nmm specific
			void setBranchId(int id);
			int getBranchId();
			bool insertInto(NMM::GraphHandler* graph);

		private:
			QList<VideoEffect*> m_effects;
			QList<QObject*> m_outputs;
			int m_branchId;
			NMM::INode* m_sink;
	};
}} //namespace Phonon::nmm

#endif // Phonon_NMM_VIDEOPATH_H
// vim: sw=4 ts=4 tw=80 noet
