/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

//nmm specific
#include "nmm/base/ProxyObject.hpp"
#include "nmm/interfaces/file/IFileHandler.hpp"
 using namespace NMM;


#include "mediaobject.h"
#include "backend.h"
#include <QTimer>
#include <QString>
#include <kdebug.h>

#include <iostream>

using namespace std;

namespace Phonon
{
namespace nmm
{
MediaObject::MediaObject( Backend* backend, QObject* parent )
	: AbstractMediaProducer( backend, parent )
	, m_backend( backend )
{
	kDebug(1234) << k_funcinfo << endl;
}

MediaObject::~MediaObject()
{
	kDebug(1234) << k_funcinfo << endl;
}

qint64 MediaObject::totalTime() const
{
	return AbstractMediaProducer::totalTime();
}

void MediaObject::registerEventHandler()
{
	kDebug(1234) << k_funcinfo << endl;
	AbstractMediaProducer::registerEventHandler(); //important: always call registerEventHandler from base class as well, or some event will not be received!

	//m_eventHandlerRegistered = true; //this is done in AbstractMediaProducer::registerEventHandler()
}

KUrl MediaObject::url() const
{
	kDebug(1234) << k_funcinfo << endl;
	if( m_graphHandler && m_graphHandler->getURL() )
		return QString::fromUtf8( m_graphHandler->getURL()->getURL().c_str() );
	return KUrl();
}

void MediaObject::setUrl( const KUrl& url )
{
	kDebug(1234) << k_funcinfo << endl;
	
	AbstractMediaProducer::setUrl(url);

	//if a url was already set, the GraphHandler has to be deleted and a new one created
	if (m_graphHandler)
	{
		if (m_graphHandler->stageReached())
		{
			deinitGraphHandler();
			initGraphHandler();
		}
	}
	else
		initGraphHandler();
	

	
	m_graphHandler->setURL(m_url);
	kDebug(1234) << "using url: " << m_graphHandler->getURL()->getURL().c_str() << endl;

	try
	{
        QString forceByteStream(getenv( "PHONON_FORCE_BYTESTREAM" ));
        if (! forceByteStream.isEmpty()) throw 0;
		m_graphHandler->stage1();
	}
	catch(...)
	{
		//TODO add better error msg
		kDebug(1234) << "NMM's GraphHandler failed" << endl;
		setState( Phonon::ErrorState );
		return;
	}
	stage1Reached();
}


void MediaObject::play()
{
	kDebug(1234) << k_funcinfo << endl;
	AbstractMediaProducer::play();
}

void MediaObject::pause()
{
	kDebug(1234) << k_funcinfo << endl;
	if( state() == PlayingState || state() == PausedState || state() == BufferingState )
	{
		AbstractMediaProducer::pause();
	}
}

void MediaObject::stop()
{
	kDebug(1234) << k_funcinfo << endl;
	AbstractMediaProducer::stop();
	m_aboutToFinishNotEmitted = true;
}

void MediaObject::seek( qint64 time )
{
	kDebug(1234) << k_funcinfo << endl;
	AbstractMediaProducer::seek( time );

	if( currentTime() < m_trackDuration - m_aboutToFinishTime ) // not about to finish
		m_aboutToFinishNotEmitted = true;
}


}}

#include "mediaobject.moc"
// vim: sw=4 ts=4 tw=80 noet
