/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "qbtgstreamerpipeline.h"

QbtGStreamerPipeline::QbtGStreamerPipeline(const QString& name)
{
    if (name.isEmpty())
        setGstElement(gst_pipeline_new(NULL));
    else
        setGstElement(gst_pipeline_new(name.toLocal8Bit().data()));

    setGstBin(GST_BIN(gstElement()));
    m_object = GST_OBJECT(gstElement());
    m_pipeline = GST_PIPELINE(gstElement());
}

QbtGStreamerPipeline::~QbtGStreamerPipeline()
{
}

bool QbtGStreamerPipeline::setClock(QbtGStreamerClock *clock)
{
    return gst_pipeline_set_clock(m_pipeline, clock->gstClock());
}

QbtGStreamerClock *QbtGStreamerPipeline::clock()
{
    QbtGStreamerClock *c = new QbtGStreamerClock;

    GstClock *gstClock = gst_pipeline_get_clock(m_pipeline);

    c->setGstClock(gstClock);
    return c;
}

void QbtGStreamerPipeline::useClock(QbtGStreamerClock *clock)
{
    gst_pipeline_use_clock(m_pipeline, clock->gstClock());
}

void QbtGStreamerPipeline::autoClock()
{
    gst_pipeline_auto_clock(m_pipeline);
}

void QbtGStreamerPipeline::setAutoFlushBus(bool autoFlush)
{
    gst_pipeline_set_auto_flush_bus(m_pipeline, autoFlush);
}

bool QbtGStreamerPipeline::autoFlushBus()
{
    gst_pipeline_get_auto_flush_bus(m_pipeline);
}

#include "qbtgstreamerpipeline.moc"

