/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERPAD
#define QBTGSTREAMERPAD

#include "qbtgstreamerobject.h"
#include "qbtgstreamercapabilities.h"
#include "qbtgstreamer_export.h"
#include <gst/gst.h>

enum QbtGStreamerPadLinkReturn
{
    QbtGStreamerPadLinkOk =  0,
    QbtGStreamerPadLinkWrongHierarchy = -1,
    QbtGStreamerPadLinkWasLinked = -2,
    QbtGStreamerPadLinkWrongDirection = -3,
    QbtGStreamerPadLinkNoFormat = -4,
    QbtGStreamerPadLinkNoScheduling = -5,
    QbtGStreamerPadLinkRefused = -6
};

class QBTGSTREAMER_EXPORT QbtGStreamerPad : public QbtGStreamerObject
{
public:
    /*GstPad* gst_pad_new(const gchar *name, GstPadDirection direction);*/
    QbtGStreamerPad();
    ~QbtGStreamerPad();

    GstPad *gstPad();
    void setGstPad(GstPad *pad);

    /*GstPadLinkReturn gst_pad_link(GstPad *srcpad, GstPad *sinkpad);*/
    QbtGStreamerPadLinkReturn link(QbtGStreamerPad *sink);

    /*gboolean gst_pad_unlink(GstPad *srcpad, GstPad *sinkpad);*/
    bool unlink(QbtGStreamerPad *sink);

    /*gboolean gst_pad_is_linked(GstPad *pad);*/
    bool linked();

    /*gboolean gst_pad_can_link(GstPad *srcpad, GstPad *sinkpad);*/
    bool canLink(QbtGStreamerPad *sink);

    /*GstPad* gst_pad_get_peer(GstPad *pad);*/
    QbtGStreamerPad *peer();

    /*void gst_pad_use_fixed_caps(GstPad *pad);*/
    void useFixedCaps();

    /*gboolean gst_pad_set_active(GstPad *pad, gboolean active);*/
    bool setActive(bool active);

    /*gboolean gst_pad_is_active(GstPad *pad);*/
    bool active();

    /*gboolean gst_pad_set_blocked(GstPad *pad, gboolean blocked);*/
    bool setBlocked(bool blocked);

    /*gboolean gst_pad_is_blocked(GstPad *pad);*/
    bool blocked();

    /*GstCaps* gst_pad_peer_get_caps(GstPad *pad);*/
    QbtGStreamerCapabilities* capabilities();

protected:
    GstPad *m_pad;
};

#if 0



            GstPad;
enum        GstPadDirection;
enum        GstPadFlags;
enum        GstPadLinkReturn;
#define     GST_PAD_LINK_FAILED             (ret)
#define     GST_PAD_LINK_SUCCESSFUL         (ret)
enum        GstFlowReturn;
enum        GstActivateMode;

#define     gst_pad_get_name                (pad)
GstPadDirection gst_pad_get_direction       (GstPad *pad);
#define     gst_pad_get_parent              (pad)
GstElement* gst_pad_get_parent_element      (GstPad *pad);
GstPadTemplate* gst_pad_get_pad_template    (GstPad *pad);




GstCaps*    gst_pad_get_caps                (GstPad *pad);
GstCaps*    gst_pad_get_allowed_caps        (GstPad *srcpad);
GstCaps*    gst_pad_get_negotiated_caps     (GstPad *pad);
const GstCaps* gst_pad_get_pad_template_caps
                                            (GstPad *pad);
gboolean    gst_pad_set_caps                (GstPad *pad,
                                             GstCaps *caps);





gboolean    gst_pad_set_blocked_async       (GstPad *pad,
                                             gboolean blocked,
                                             GstPadBlockCallback callback,
                                             gpointer user_data);
void        (*GstPadBlockCallback)          (GstPad *pad,
                                             gboolean blocked,
                                             gpointer user_data);

gulong      gst_pad_add_data_probe          (GstPad *pad,
                                             GCallback handler,
                                             gpointer data);
gulong      gst_pad_add_buffer_probe        (GstPad *pad,
                                             GCallback handler,
                                             gpointer data);
gulong      gst_pad_add_event_probe         (GstPad *pad,
                                             GCallback handler,
                                             gpointer data);
void        gst_pad_remove_data_probe       (GstPad *pad,
                                             guint handler_id);
void        gst_pad_remove_buffer_probe     (GstPad *pad,
                                             guint handler_id);
void        gst_pad_remove_event_probe      (GstPad *pad,
                                             guint handler_id);


GstPad*     gst_pad_new_from_template       (GstPadTemplate *templ,
                                             const gchar *name);
GstPad*     gst_pad_new_from_static_template
                                            (GstStaticPadTemplate *templ,
                                             const gchar *name);
GstFlowReturn gst_pad_alloc_buffer          (GstPad *pad,
                                             guint64 offset,
                                             gint size,
                                             GstCaps *caps,
                                             GstBuffer **buf);
GstFlowReturn gst_pad_alloc_buffer_and_set_caps
                                            (GstPad *pad,
                                             guint64 offset,
                                             gint size,
                                             GstCaps *caps,
                                             GstBuffer **buf);
void        gst_pad_set_bufferalloc_function
                                            (GstPad *pad,
                                             GstPadBufferAllocFunction bufalloc);
GstFlowReturn (*GstPadBufferAllocFunction)  (GstPad *pad,
                                             guint64 offset,
                                             guint size,
                                             GstCaps *caps,
                                             GstBuffer **buf);
void        gst_pad_set_chain_function      (GstPad *pad,
                                             GstPadChainFunction chain);
GstFlowReturn (*GstPadChainFunction)        (GstPad *pad,
                                             GstBuffer *buffer);
void        gst_pad_set_checkgetrange_function
                                            (GstPad *pad,
                                             GstPadCheckGetRangeFunction check);
gboolean    (*GstPadCheckGetRangeFunction)  (GstPad *pad);
GstFlowReturn gst_pad_get_range             (GstPad *pad,
                                             guint64 offset,
                                             guint size,
                                             GstBuffer **buffer);
void        gst_pad_set_getrange_function   (GstPad *pad,
                                             GstPadGetRangeFunction get);
GstFlowReturn (*GstPadGetRangeFunction)     (GstPad *pad,
                                             guint64 offset,
                                             guint length,
                                             GstBuffer **buffer);
void        gst_pad_set_event_function      (GstPad *pad,
                                             GstPadEventFunction event);
gboolean    (*GstPadEventFunction)          (GstPad *pad,
                                             GstEvent *event);
void        gst_pad_set_link_function       (GstPad *pad,
                                             GstPadLinkFunction link);
GstPadLinkReturn (*GstPadLinkFunction)      (GstPad *pad,
                                             GstPad *peer);
void        gst_pad_set_unlink_function     (GstPad *pad,
                                             GstPadUnlinkFunction unlink);
void        (*GstPadUnlinkFunction)         (GstPad *pad);
gboolean    gst_pad_accept_caps             (GstPad *pad,
                                             GstCaps *caps);
void        gst_pad_set_acceptcaps_function (GstPad *pad,
                                             GstPadAcceptCapsFunction acceptcaps);
gboolean    (*GstPadAcceptCapsFunction)     (GstPad *pad,
                                             GstCaps *caps);
void        gst_pad_set_getcaps_function    (GstPad *pad,
                                             GstPadGetCapsFunction getcaps);
GstCaps*    (*GstPadGetCapsFunction)        (GstPad *pad);
GstCaps*    gst_pad_proxy_getcaps           (GstPad *pad);
void        gst_pad_set_setcaps_function    (GstPad *pad,
                                             GstPadSetCapsFunction setcaps);
gboolean    (*GstPadSetCapsFunction)        (GstPad *pad,
                                             GstCaps *caps);
gboolean    gst_pad_proxy_setcaps           (GstPad *pad,
                                             GstCaps *caps);
void        gst_pad_fixate_caps             (GstPad *pad,
                                             GstCaps *caps);
void        gst_pad_set_fixatecaps_function (GstPad *pad,
                                             GstPadFixateCapsFunction fixatecaps);
void        (*GstPadFixateCapsFunction)     (GstPad *pad,
                                             GstCaps *caps);
GstCaps*    gst_pad_get_fixed_caps_func     (GstPad *pad);
gboolean    gst_pad_peer_accept_caps        (GstPad *pad,
                                             GstCaps *caps);
void        gst_pad_set_activate_function   (GstPad *pad,
                                             GstPadActivateFunction activate);
gboolean    (*GstPadActivateFunction)       (GstPad *pad);
void        gst_pad_set_activatepush_function
                                            (GstPad *pad,
                                             GstPadActivateModeFunction activatepush);
void        gst_pad_set_activatepull_function
                                            (GstPad *pad,
                                             GstPadActivateModeFunction activatepull);
gboolean    (*GstPadActivateModeFunction)   (GstPad *pad,
                                             gboolean active);
GstFlowReturn gst_pad_push                  (GstPad *pad,
                                             GstBuffer *buffer);
gboolean    gst_pad_push_event              (GstPad *pad,
                                             GstEvent *event);
gboolean    gst_pad_check_pull_range        (GstPad *pad);
GstFlowReturn gst_pad_pull_range            (GstPad *pad,
                                             guint64 offset,
                                             guint size,
                                             GstBuffer **buffer);
gboolean    gst_pad_activate_pull           (GstPad *pad,
                                             gboolean active);
gboolean    gst_pad_activate_push           (GstPad *pad,
                                             gboolean active);
gboolean    gst_pad_send_event              (GstPad *pad,
                                             GstEvent *event);
gboolean    gst_pad_event_default           (GstPad *pad,
                                             GstEvent *event);
gboolean    gst_pad_query                   (GstPad *pad,
                                             GstQuery *query);
gboolean    gst_pad_query_default           (GstPad *pad,
                                             GstQuery *query);
gboolean    gst_pad_query_position          (GstPad *pad,
                                             GstFormat *format,
                                             gint64 *cur);
gboolean    gst_pad_query_duration          (GstPad *pad,
                                             GstFormat *format,
                                             gint64 *duration);
gboolean    gst_pad_query_convert           (GstPad *pad,
                                             GstFormat src_format,
                                             gint64 src_val,
                                             GstFormat *dest_format,
                                             gint64 *dest_val);
gboolean    gst_pad_query_peer_position     (GstPad *pad,
                                             GstFormat *format,
                                             gint64 *cur);
gboolean    gst_pad_query_peer_duration     (GstPad *pad,
                                             GstFormat *format,
                                             gint64 *duration);
gboolean    gst_pad_query_peer_convert      (GstPad *pad,
                                             GstFormat src_format,
                                             gint64 src_val,
                                             GstFormat *dest_format,
                                             gint64 *dest_val);
void        gst_pad_set_query_function      (GstPad *pad,
                                             GstPadQueryFunction query);
gboolean    (*GstPadQueryFunction)          (GstPad *pad,
                                             GstQuery *query);
void        gst_pad_set_query_type_function (GstPad *pad,
                                             GstPadQueryTypeFunction type_func);
const GstQueryType* (*GstPadQueryTypeFunction)
                                            (GstPad *pad);
const GstQueryType* gst_pad_get_query_types (GstPad *pad);
const GstQueryType* gst_pad_get_query_types_default
                                            (GstPad *pad);
void        gst_pad_set_internal_link_function
                                            (GstPad *pad,
                                             GstPadIntLinkFunction intlink);
GList*      (*GstPadIntLinkFunction)        (GstPad *pad);
GList*      gst_pad_get_internal_links      (GstPad *pad);
GList*      gst_pad_get_internal_links_default
                                            (GstPad *pad);
void        gst_pad_load_and_link           (xmlNodePtr self,
                                             GstObject *parent);
gboolean    gst_pad_dispatcher              (GstPad *pad,
                                             GstPadDispatcherFunction dispatch,
                                             gpointer data);
gboolean    (*GstPadDispatcherFunction)     (GstPad *pad,
                                             gpointer data);
void        gst_pad_set_element_private     (GstPad *pad,
                                             gpointer priv);
gpointer    gst_pad_get_element_private     (GstPad *pad);

GstFlowReturn gst_pad_chain                 (GstPad *pad,
                                             GstBuffer *buffer);
gboolean    gst_pad_start_task              (GstPad *pad,
                                             GstTaskFunction func,
                                             gpointer data);
gboolean    gst_pad_pause_task              (GstPad *pad);
gboolean    gst_pad_stop_task               (GstPad *pad);

#define     GST_PAD_GET_STREAM_LOCK         (pad)
#define     GST_PAD_STREAM_LOCK             (pad)
#define     GST_PAD_STREAM_LOCK_FULL        (pad,t)
#define     GST_PAD_STREAM_TRYLOCK          (pad)
#define     GST_PAD_STREAM_UNLOCK           (pad)
#define     GST_PAD_STREAM_UNLOCK_FULL      (pad)
#define     GST_FLOW_IS_FATAL               (ret)
#define     GST_FLOW_IS_SUCCESS             (ret)
#endif

#endif
