/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "qbtgstreamerobject.h"

#include <QtDebug>

QbtGStreamerObject::QbtGStreamerObject() : QObject()
{
}

QbtGStreamerObject::QbtGStreamerObject(const QbtGStreamerObject& obj) : QObject()
{
    *this = obj;
}

QbtGStreamerObject& QbtGStreamerObject::operator= (const QbtGStreamerObject& obj)
{
    *this = obj;
    return *this;
}

QbtGStreamerObject::~QbtGStreamerObject()
{
}

void QbtGStreamerObject::setProperty(const QString& , const QString& )
{
    //g_object_set(G_OBJECT(m_source), property.toLocal8Bit().data(), value.toLocal8Bit().data(), QBTGSTREAMER_NULL);
}

void QbtGStreamerObject::connectSignal(const QString& signal, void *slot)
{
    //qDebug() << "connecting " << signal;
    g_signal_connect(m_object, signal.toLocal8Bit().data(), G_CALLBACK(slot), NULL);
    // implement in subclass.
    // add a GstObject m_object, in subclass do GST_OBJECT(element), then use m_object.
}

QString QbtGStreamerObject::name()
{
    return QString(gst_object_get_name(m_object));
}

void QbtGStreamerObject::setGstObject(GstObject *object)
{
    m_object = object;
}

GstObject *QbtGStreamerObject::gstObject()
{
    return m_object;
}

#include "qbtgstreamerobject.moc"

