/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERMESSAGE
#define QBTGSTREAMERMESSAGE

#include <QString>

#include "qbtgstreamerobject.h"
#include "qbtgstreamerstructure.h"
#include "qbtgstreamererror.h"
#include "qbtgstreamer_export.h"
#include <gst/gst.h>

enum QbtGStreamerMessageType
{
    QbtGStreamerMessageUnknown,
    QbtGStreamerMessageEos,
    QbtGStreamerMessageError,
    QbtGStreamerMessageWarning,
    QbtGStreamerMessageInfo,
    QbtGStreamerMessageTag,
    QbtGStreamerMessageBuffering,
    QbtGStreamerMessageStateChanged,
    QbtGStreamerMessageStateDirty,
    QbtGStreamerMessageStepDone,
    QbtGStreamerMessageClockProvide,
    QbtGStreamerMessageClockLost,
    QbtGStreamerMessageNewClock,
    QbtGStreamerMessageStructureChange,
    QbtGStreamerMessageStreamStatus,
    QbtGStreamerMessageApplication,
    QbtGStreamerMessageElement,
    QbtGStreamerMessageSegmentStart,
    QbtGStreamerMessageSegmentDone,
    QbtGStreamerMessageDuration,
    QbtGStreamerMessageAny
};

class QBTGSTREAMER_EXPORT QbtGStreamerMessage
{
public:
    QbtGStreamerMessage();

    QbtGStreamerMessageType type();
    qint64 timestamp();
    QbtGStreamerObject *sourceObject();
    QbtGStreamerStructure *structure();

    /*const gchar* gst_message_type_get_name(GstMessageType type);*/
    QString typeName(QbtGStreamerMessageType type);

    /*void gst_message_parse_error(GstMessage *message, GError **gerror, gchar **debug);*/
    QbtGStreamerError *error(QString& debugMessage);

    /*void        gst_message_parse_state_changed (GstMessage *message,
                                             GstState *oldstate,
                                             GstState *newstate,
                                             GstState *pending);*/
    void stateChanged(GstState *oldstate, GstState *newstate, GstState *pending) {gst_message_parse_state_changed(m_message, oldstate, newstate, pending);}

    void setGstMessage(GstMessage *message);
    GstMessage *gstMessage();

private:
    QbtGStreamerMessageType getType(GstMessageType type);
    GstMessageType getGstMessageType(QbtGStreamerMessageType type);
    GstMessage *m_message;

};

#if 0
#include <gst/gst.h>


            GstMessage;
enum        GstMessageType;
#define     GST_MESSAGE_SRC                 (message)
#define     GST_MESSAGE_TIMESTAMP           (message)
#define     GST_MESSAGE_TYPE                (message)
#define     GST_MESSAGE_TYPE_NAME           (message)
#define     GST_MESSAGE_TRACE_NAME
GQuark      gst_message_type_to_quark       (GstMessageType type);
#define     gst_message_copy                (msg)
const GstStructure* gst_message_get_structure
                                            (GstMessage *message);
#define     gst_message_make_writable       (msg)
GstMessage* gst_message_new_application     (GstObject *src,
                                             GstStructure *structure);
GstMessage* gst_message_new_clock_provide   (GstObject *src,
                                             GstClock *clock,
                                             gboolean ready);
GstMessage* gst_message_new_clock_lost      (GstObject *src,
                                             GstClock *clock);
GstMessage* gst_message_new_custom          (GstMessageType type,
                                             GstObject *src,
                                             GstStructure *structure);
GstMessage* gst_message_new_element         (GstObject *src,
                                             GstStructure *structure);
GstMessage* gst_message_new_eos             (GstObject *src);
GstMessage* gst_message_new_error           (GstObject *src,
                                             GError *error,
                                             gchar *debug);
GstMessage* gst_message_new_new_clock       (GstObject *src,
                                             GstClock *clock);
GstMessage* gst_message_new_segment_done    (GstObject *src,
                                             GstFormat format,
                                             gint64 position);
GstMessage* gst_message_new_segment_start   (GstObject *src,
                                             GstFormat format,
                                             gint64 position);
GstMessage* gst_message_new_state_changed   (GstObject *src,
                                             GstState oldstate,
                                             GstState newstate,
                                             GstState pending);
GstMessage* gst_message_new_tag             (GstObject *src,
                                             GstTagList *tag_list);
GstMessage* gst_message_new_buffering       (GstObject *src,
                                             gint percent);
GstMessage* gst_message_new_warning         (GstObject *src,
                                             GError *error,
                                             gchar *debug);
GstMessage* gst_message_new_duration        (GstObject *src,
                                             GstFormat format,
                                             gint64 duration);
GstMessage* gst_message_new_state_dirty     (GstObject *src);
void        gst_message_parse_clock_lost    (GstMessage *message,
                                             GstClock **clock);
void        gst_message_parse_clock_provide (GstMessage *message,
                                             GstClock **clock,
                                             gboolean *ready);
void        gst_message_parse_error         (GstMessage *message,
                                             GError **gerror,
                                             gchar **debug);
void        gst_message_parse_new_clock     (GstMessage *message,
                                             GstClock **clock);
void        gst_message_parse_segment_done  (GstMessage *message,
                                             GstFormat *format,
                                             gint64 *position);
void        gst_message_parse_segment_start (GstMessage *message,
                                             GstFormat *format,
                                             gint64 *position);
void        gst_message_parse_state_changed (GstMessage *message,
                                             GstState *oldstate,
                                             GstState *newstate,
                                             GstState *pending);
void        gst_message_parse_tag           (GstMessage *message,
                                             GstTagList **tag_list);
void        gst_message_parse_buffering     (GstMessage *message,
                                             gint *percent);
void        gst_message_parse_warning       (GstMessage *message,
                                             GError **gerror,
                                             gchar **debug);
void        gst_message_parse_duration      (GstMessage *message,
                                             GstFormat *format,
                                             gint64 *duration);
GstMessage* gst_message_ref                 (GstMessage *msg);
#define     gst_message_unref               (msg)
#endif

#endif
