/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERCAPABILITIES
#define QBTGSTREAMERCAPABILITIES

#include <QString>
#include "qbtgstreamer_export.h"
#include <gst/gst.h>

class QBTGSTREAMER_EXPORT QbtGStreamerCapabilities
{
public:
    QbtGStreamerCapabilities();
    ~QbtGStreamerCapabilities();

    /*gchar* gst_caps_to_string(const GstCaps *caps);*/
    QString toString();

    /*GstCaps* gst_caps_intersect(const GstCaps *caps1, const GstCaps *caps2);*/
    QbtGStreamerCapabilities* intersect(QbtGStreamerCapabilities* caps);

    /*gboolean gst_caps_is_empty(const GstCaps *caps);*/
    bool isEmpty();

    void setGstCaps(GstCaps* caps);
    GstCaps* gstCaps();

private:
    GstCaps* m_caps;
};

#if 0



            GstCaps;
            GstStaticCaps;
enum        GstCapsFlags;
#define     GST_CAPS_ANY
#define     GST_CAPS_NONE
#define     GST_CAPS_REFCOUNT               (caps)
#define     GST_CAPS_REFCOUNT_VALUE         (caps)
#define     GST_STATIC_CAPS_ANY
#define     GST_STATIC_CAPS_NONE
#define     GST_CAPS_IS_SIMPLE              (caps)
#define     GST_DEBUG_CAPS                  (string, caps)
#define     GST_STATIC_CAPS                 (string)
GstCaps*    gst_caps_new_empty              (void);
GstCaps*    gst_caps_new_any                (void);
GstCaps*    gst_caps_new_simple             (const char *media_type,
                                             const char *fieldname,
                                             ...);
GstCaps*    gst_caps_new_full               (GstStructure *struct1,
                                             ...);
GstCaps*    gst_caps_new_full_valist        (GstStructure *structure,
                                             va_list var_args);
GstCaps*    gst_caps_copy                   (const GstCaps *caps);
GstCaps*    gst_caps_copy_nth               (const GstCaps *caps,
                                             guint nth);
GstCaps*    gst_static_caps_get             (GstStaticCaps *static_caps);
void        gst_caps_append                 (GstCaps *caps1,
                                             GstCaps *caps2);
void        gst_caps_merge                  (GstCaps *caps1,
                                             GstCaps *caps2);
void        gst_caps_append_structure       (GstCaps *caps,
                                             GstStructure *structure);
void        gst_caps_remove_structure       (GstCaps *caps,
                                             guint idx);
void        gst_caps_merge_structure        (GstCaps *caps,
                                             GstStructure *structure);
guint       gst_caps_get_size               (const GstCaps *caps);
GstStructure* gst_caps_get_structure        (const GstCaps *caps,
                                             guint index);
void        gst_caps_set_simple             (GstCaps *caps,
                                             char *field,
                                             ...);
void        gst_caps_set_simple_valist      (GstCaps *caps,
                                             char *field,
                                             va_list varargs);
gboolean    gst_caps_is_any                 (const GstCaps *caps);

gboolean    gst_caps_is_fixed               (const GstCaps *caps);
gboolean    gst_caps_is_equal               (const GstCaps *caps1,
                                             const GstCaps *caps2);
gboolean    gst_caps_is_equal_fixed         (const GstCaps *caps1,
                                             const GstCaps *caps2);
gboolean    gst_caps_is_always_compatible   (const GstCaps *caps1,
                                             const GstCaps *caps2);
gboolean    gst_caps_is_subset              (const GstCaps *subset,
                                             const GstCaps *superset);
GstCaps*    gst_caps_union                  (const GstCaps *caps1,
                                             const GstCaps *caps2);
GstCaps*    gst_caps_normalize              (const GstCaps *caps);
gboolean    gst_caps_do_simplify            (GstCaps *caps);
xmlNodePtr  gst_caps_save_thyself           (const GstCaps *caps,
                                             xmlNodePtr parent);
GstCaps*    gst_caps_load_thyself           (xmlNodePtr parent);
void        gst_caps_replace                (GstCaps **caps,
                                             GstCaps *newcaps);

GstCaps*    gst_caps_from_string            (const gchar *string);
GstCaps*    gst_caps_subtract               (const GstCaps *minuend,
                                             const GstCaps *subtrahend);
GstCaps*    gst_caps_make_writable          (GstCaps *caps);
GstCaps*    gst_caps_ref                    (GstCaps *caps);
void        gst_caps_truncate               (GstCaps *caps);
void        gst_caps_unref                  (GstCaps *caps);
#endif

#endif
