/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "qbtgstreamercallbackmanager.h"

#include <QtDebug>
#include <QMetaType>

#include <gst/gst.h>

QbtGStreamerCallbackManager* QbtGStreamerCallbackManager::m_instance = 0;

QbtGStreamerCallbackManager* QbtGStreamerCallbackManager::Instance()
{
  if (m_instance == 0)
  {
    //qDebug() << "Creating new callback manager instance.";
    m_instance = new QbtGStreamerCallbackManager;

    // Register qpointer here as it is only done once (singleton).
    // This is needed for QObject to connect signals with a gpointer parameter.
    qRegisterMetaType<gpointer>("gpointer");
  }
  return m_instance;
}

QbtGStreamerCallbackManager::QbtGStreamerCallbackManager()
{
}
