/*  This file is part of the KDE project
    Copyright (C) 2006 Matthias Kretz <kretz@kde.org>
    Copyright (C) 2006-2007 Tim Beaulen <tbscope@gmail.com>

    Based on code by Fluendo:
    Copyright (C) 2006 Wim Taymans <wim@fluendo.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "pipelineview.h"


#include <QString>
#include <QByteArray>
#include <QGraphicsScene>
#include <QRectF>
#include <QFontMetrics>
#include <QFont>
#include <QtGlobal>
#include <QPixmap>
#include <QPixmapCache>
#include <QImage>
#include <QPainterPath>

#include "pipelineviewer/controlitem.h"

#include <kdebug.h>

namespace Phonon
{
namespace GStreamer
{

PipelineView *PipelineView::m_instance;

PipelineView::PipelineView()
{
    setCacheMode(QGraphicsView::CacheBackground);
    setResizeAnchor(QGraphicsView::NoAnchor);

    m_instance = this;

    m_scene = new QGraphicsScene(this);
    setScene(m_scene);

    m_scene->addItem(new ControlItem(this));
}

PipelineView::~PipelineView()
{
}

PipelineView *PipelineView::instance()
{
    if (!m_instance)
        return new PipelineView;

    return m_instance;
}

void PipelineView::setXmlDoc(const QDomDocument &doc)
{
    QDomElement root = doc.documentElement();

    if (!(root.tagName() == "gstreamer")) {
        kWarning(611) << "Only gstreamer xml documents allowed!" << endl;
        return;
    }

    QDomElement child = root.firstChildElement("gst:element");
    while (!child.isNull()) {
        parseElement(child);
        child = child.nextSiblingElement("gst:element");
    }
}

void PipelineView::parseElement(const QDomElement &element)
{
    QString type = element.firstChildElement("gst:type").text();
    //m_scene->addText(type);

    if (type == "pipeline") {
            //m_scene->addItem(new PipelineItem(element));
    }
}

}} // Phonon::GStreamer
