/*  This file is part of the KDE project
    Copyright (C) 2006 Matthias Kretz <kretz@kde.org>
    Copyright (C) 2006-2007 Tim Beaulen <tbscope@gmail.com>

    Based on code by Fluendo:
    Copyright (C) 2006 Wim Taymans <wim@fluendo.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef PHONON_GSTREAMER_PARAMITEM_H
#define PHONON_GSTREAMER_PARAMITEM_H

#include <QGraphicsItem>

class QString;
class QDomElement;
class QRectF;
class QStyleOptionGraphicsItem;
class QWidget;
class QPainter;

namespace Phonon
{
namespace GStreamer
{
    
    class ParamItem : public QGraphicsItem
    {
        public:
            ParamItem(const QDomElement &element, QGraphicsItem *parent = 0);
            QRectF boundingRect() const;
            void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

        private:
            QPixmap cached(const QString &img);
            QString m_paramName;
            QString m_paramValue;

            QPixmap titleStretch;
            QPixmap titleLeft;
            QPixmap titleRight;
    };

}} // Phonon::GStreamer

#endif
