/*  This file is part of the KDE project
    Copyright (C) 2004-2006 Matthias Kretz <kretz@kde.org>
    Copyright (C) 2006-2007 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef PHONON_GSTREAMER_BACKEND_H
#define PHONON_GSTREAMER_BACKEND_H

#include <QList>
#include <QPointer>
#include <QStringList>

#include <phonon/objectdescription.h>
#include <phonon/backendinterface.h>

#include <kdelibs_export.h>

#include "qbtgstreamer/qbtgstreamer.h"
#include "qbtgstreamer/qbtgstreamerelement.h"
#include "qbtgstreamer/qbtgstreamerpipeline.h"
#include "qbtgstreamer/qbtgstreamercapabilities.h"
#include "qbtgstreamer/coreplugins/qbtgstreamertypefindelement.h"

#include "playbin.h"


class KUrl;

namespace Phonon
{
namespace GStreamer
{
    class AudioOutput;

    class Backend : public QObject, public BackendInterface
    {
        Q_OBJECT
        Q_INTERFACES(Phonon::BackendInterface)

        public:
            Backend(QObject *parent, const QStringList &args);
            virtual ~Backend();

            QObject* createObject0(BackendInterface::Class0, QObject *parent);
            QObject* createObject1(BackendInterface::Class1, QObject *parent, QVariant arg1);

            Q_INVOKABLE bool supportsVideo() const;
            Q_INVOKABLE bool supportsOSD() const;
            Q_INVOKABLE bool supportsFourcc(quint32 fourcc) const;
            Q_INVOKABLE bool supportsSubtitles() const;
            Q_INVOKABLE QStringList knownMimeTypes() const;

            void freeSoundcardDevices();

            QSet<int> objectDescriptionIndexes(ObjectDescriptionType type) const;
            QHash<QByteArray, QVariant> objectDescriptionProperties(ObjectDescriptionType, int) const;

            Q_INVOKABLE char const *uiLibrary() const;
            // Q_INVOKABLE char *uiSymbol() const;

            QbtGStreamerElement *sourceElement();
            QbtGStreamerPipeline *pipeline();
            PlayBin *player();

            static Backend *instance() {return m_instance;}

        private slots:
            void slotHaveType(QbtGStreamerTypeFindElement *, uint, QbtGStreamerCapabilities *, QbtGStreamerDataPointer *);

        private:
            static Backend *m_instance;
            PlayBin *m_player;
            QStringList m_supportedMimeTypes;
            QStringList m_supportedAudioOutputDevices;
            QList<QPointer<AudioOutput> > m_audioOutputs;
            QbtGStreamerElement *m_sourceElement;
            QbtGStreamerElement *m_audioSink;
            QbtGStreamerTypeFindElement *m_typefindElement;
            QbtGStreamerPipeline *m_pipeline;
            QbtGStreamerElement *m_play;
            void tryToPlug(QbtGStreamerPad *, QbtGStreamerCapabilities *);
    };
}} // namespace Phonon::GStreamer

// vim: sw=4 ts=4 et tw=80
#endif // PHONON_GSTREAMER_BACKEND_H
