/*  This file is part of the KDE project
    Copyright (C) 2006 Matthias Kretz <kretz@kde.org>
    Copyright (C) 2006-2007 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef PHONON_GSTREAMER_AVCAPTURECAPTURE_H
#define PHONON_GSTREAMER_AVCAPTURECAPTURE_H

#include "abstractmediaproducer.h"

namespace Phonon
{
namespace GStreamer
{
    class AvCapture : public AbstractMediaProducer
    {
        Q_OBJECT

        public:
            AvCapture(QObject *parent);
            ~AvCapture();

        public slots:
            int audioCaptureDevice() const;
            void setAudioCaptureDevice(int index);
            int videoCaptureDevice() const;
            void setVideoCaptureDevice(int index);
    };
}} //namespace Phonon::GStreamer

// vim: sw=4 ts=4 tw=80 noet
#endif // PHONON_GSTREAMER_AVCAPTURECAPTURE_H
