/* This file is part of Noatun

  Copyright 2000-2006 Charles Samuels <charles@kde.org>
  Copyright 2000-2001 Neil Stevens <neil@qualityassistant.com>
  Copyright 2002 by Ryan Cumming <ryan@kde.org>
  Copyright 2003-2007 by Stefan Gehn <mETz81@web.de>

  Licensed under the "Artistic License"
*/
#include "playlist.h"
#include "view.h"

#include <noatun/player.h>
#include <noatun/global.h>

#include <kapplication.h>
#include <kdebug.h>
#include <kgenericfactory.h>
#include <kiconloader.h>
#include <krandomsequence.h>

#include <cassert>
using namespace Noatun;

K_EXPORT_COMPONENT_FACTORY(noatun_splitplaylist, PluginFactory<SplitPlaylist>("noatun_splitplaylist"))


ItemData::ItemData(Noatun::PlaylistInterface<ItemData*> *iface, SafeListViewItem *item)
	: mItem(item), mIface(iface)
{
	assert(item);
}

ItemData *ItemData::above()
{
	if (mItem->itemAbove())
		return new ItemData(mIface, mItem->itemAbove());
	return 0;
}

ItemData *ItemData::below()
{
	if (mItem->itemBelow())
		return new ItemData(mIface, mItem->itemBelow());
	return 0;
}





SplitPlaylist *SplitPlaylist::Self=0;


SplitPlaylist::SplitPlaylist(const KComponentData &instance, Global *global, const char* name)
	: Plugin(instance, global, name), PlaylistInterface<ItemData*>(global)
{
	currentItem = randomPrevious = 0;
	mExiting = false;
	kDebug(66666) << k_funcinfo << "with instance " << instance.componentName() << endl;
	Self = this;
	mView = new View(this);
}

SplitPlaylist::~SplitPlaylist()
{
	kDebug(66666) << k_funcinfo << "BEGIN" << endl;
	mExiting=true;
	delete mView;
	kDebug(66666) << k_funcinfo << "END" << endl;
}


void SplitPlaylist::init()
{
	kDebug(66666) << k_funcinfo << endl;
	connect(
		mView->listView(), SIGNAL(executed(Q3ListViewItem*)),
		this, SLOT(listItemSelected(Q3ListViewItem*)));
	mView->init();
}


KMainWindow *SplitPlaylist::mainWindow() const
{
	return mView;
}


void SplitPlaylist::reset()
{
	SafeListViewItem *i = mView->listView()->firstChild();
	setCurrent(i, false);
	if (i && !i->isOn())
		next(false);
}

PlaylistItem SplitPlaylist::forward()
{
	return next(true);
}

PlaylistItem SplitPlaylist::backward()
{
/*	if (Global::self()->player()->loopStyle() == Player::Random && randomPrevious)
	{
		List *list = mView->listView();
		// check if the item still exists (hackitude: 50%)
		bool found=false;
		for (Q3ListViewItem *i = list->firstChild(); i; i = i->nextSibling())
		{
			if (i == static_cast<SafeListViewItem*>(randomPrevious.data()))
			{
				found = true;
				break;
			}
		}

		if (found)
		{
			// setCurrent modified randomPrevious, and setCurrent is pass-by-reference
			PlaylistItem prev = randomPrevious;

			setCurrent(prev);
			return currentItem;
		}
	}
	*/
	// there's a possibility that I will fall out to here
	// from the above branch

	SafeListViewItem *nextItem=0;
	if(!current())
	{
		return next(false);
	}
	else
	{
		nextItem = item(current())->item()->itemAbove();
	}
	if (!nextItem) // don't set a null-item as current item
		return current();

	setCurrent(nextItem, false);

	if (currentItem)
		if (!currentItem->isOn())
			return backward();

	return current();
}

PlaylistItem SplitPlaylist::current()
{
	if (!currentItem)
		return PlaylistItem();
	else
		return item(new ItemData(this, currentItem));
}




PlaylistItem SplitPlaylist::next(bool play)
{
	SafeListViewItem *nextItem=0;

/*	if (Global::self()->player()->loopStyle() == Player::Random)
	{
		// Ignore all this order stuff and select a random item
		List *lView = mView->listView();

		if (lView->childCount())
		{
			SafeListViewItem *slvi = static_cast<SafeListViewItem*>(
					lView->itemAtIndex(KApplication::random() % lView->childCount())
				);
			nextItem = PlaylistItem(slvi);
		}
		else
		{
			nextItem = 0;
		}
	}
	else
*/	{
		if(!current())
		{
			nextItem = mView->listView()->firstChild();
		}
		else
		{
			nextItem = currentItem->itemBelow();
		}
	}

	if (!nextItem) // don't set a null-item as current item
	{
		nextItem = mView->listView()->firstChild();
	}

	SafeListViewItem *oldCurrent = currentItem;
	setCurrent(nextItem, false);

	// Hack for back button on randomized play
	if (oldCurrent)
		randomPrevious = oldCurrent;

	if (currentItem)
		if (!currentItem->isOn())
			return next(play);

	return current();
}


PlaylistItem SplitPlaylist::getFirst()
{
  SafeListViewItem* first = mView->listView()->firstChild();
  return first ? item(new ItemData(this, first)) : PlaylistItem();
}

PlaylistItem SplitPlaylist::getAfter(const PlaylistItem &i)
{
	if (i)
		return item(item(i)->below());
	return PlaylistItem();
}



QString SplitPlaylist::property(ItemData *item, const QString &k, const QString &v)
{
	SafeListViewItem *slvi = item->item();
	return slvi->property(k, v);
}

void SplitPlaylist::setProperty(ItemData *item, const QString &k, const QString &v)
{
	SafeListViewItem *slvi = item->item();
	slvi->setProperty(k, v);
}

void SplitPlaylist::clearProperty(ItemData *item, const QString &k)
{
	SafeListViewItem *slvi = item->item();
	slvi->clearProperty(k);
}

QStringList SplitPlaylist::properties(ItemData *item)
{
	SafeListViewItem *slvi = item->item();
	return slvi->properties();
}

bool SplitPlaylist::hasProperty(ItemData *item, const QString &k)
{
	SafeListViewItem *slvi = item->item();
	return slvi->hasProperty(k);
}

bool SplitPlaylist::compare(ItemData *one, ItemData *two)
{
	SafeListViewItem *a = static_cast<ItemData*>(one)->item();
	SafeListViewItem *b = static_cast<ItemData*>(two)->item();
	return a == b;
}

void SplitPlaylist::remove(ItemData *item)
{
	SafeListViewItem *slvi = static_cast<ItemData*>(item)->item();
	return slvi->remove();
}




void SplitPlaylist::clear()
{
	mView->listView()->clear();
}

void SplitPlaylist::addFile(const KUrl &file, bool purgeList, bool autoplay)
{
	if (purgeList)
		clear();
	mView->addFile(file, autoplay);
}

void SplitPlaylist::setCurrent(const PlaylistItem &i)
{
	setCurrent(item(i)->item(), true);
}

void SplitPlaylist::setCurrent(SafeListViewItem *i, bool emitC)
{
	randomPrevious = 0;
	emitC = emitC && currentItem;
	if (!i)
	{
		currentItem=0;
	}
	else
	{
		// remove the old icon
		if (currentItem)
			currentItem->showPlaying(false);

		currentItem=i;

		if(i)
			i->showPlaying(true);
	}

	if (emitC && !exiting())
	{
		// newCurrent();
		//Global::self()->player()->play();
	}
}

void SplitPlaylist::remove(const PlaylistItem &)
{
//	delete i;
}

void SplitPlaylist::listItemSelected(Q3ListViewItem *i)
{
	SafeListViewItem *slvi = static_cast<SafeListViewItem*>(i);
	PlaylistItem pli = item(new ItemData(this, slvi));
	if (slvi)
		Plugin::global()->player()->play(pli);
}

void SplitPlaylist::randomize()
{
	// turning off sorting is necessary
	// otherwise, the list will get randomized and promptly sorted again
	mView->setSorting(false);
	List *lView = mView->listView();
	QList<int> list;
	QList<Q3ListViewItem*> items;
	for(int i = 0; i < lView->childCount(); i++)
	{
		list.append( i );
		items.append( lView->itemAtIndex( i ) );
	}

	KRandomSequence seq;
	seq.randomize<int>( list );

	for(int i = 0; i < lView->childCount(); i++)
	{
		items.first()->moveItem(lView->itemAtIndex(list.first()));
		items.pop_front();
		list.pop_front();
	}

	setCurrent(currentItem, false);
}

void SplitPlaylist::sort()
{
	mView->setSorting(true);
	setCurrent(currentItem, false);
}

#include "playlist.moc"
