/***************************************************************************
                     A simple database-driven playlist for Noatun
                    ---------------------------------------------
    begin                : 25.05.2005
    copyright            : (C) 2005 by Stefan Gehn
    email                : Stefan Gehn <mETz81@web.de>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SIMPLEMAINWINDOW_H
#define SIMPLEMAINWINDOW_H

#include <noatun/nmainwindow.h>

class SimplePlaylist;
class SimpleListView;
class KFileDialog;
class KListView;
class QListViewItem;

class SimpleMainWindow : public Noatun::NMainWindow
{
Q_OBJECT
public:
	explicit SimpleMainWindow(SimplePlaylist *parent);
	~SimpleMainWindow();
	SimpleListView *listView() const;

private Q_SLOTS:
	void addFiles();
	void slotFilesSelected();
	void slotAddFilesDlgDestroyed();
	void slotUpdateActionStatus();
	void slotShowProperties();
	void slotContextMenu(KListView*, QListViewItem *lvi, const QPoint& p);

private:
	SimpleListView *mListView;
	SimplePlaylist *playlist;
	KFileDialog *mAddFilesDlg;

	KAction *mPlayCurrent, *mDelete, *mShowProperties;
}; // END class SimpleMainWindow

#endif
