/***************************************************************************
                     A simple database-driven playlist for Noatun
                    ---------------------------------------------
    begin                : 25.05.2005
    copyright            : (C) 2005 by Stefan Gehn
    email                : Stefan Gehn <mETz81@web.de>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "simplemainwindow.h"
#include "simpleplaylist.h"
#include "simplelistview.h"

#include <noatun/global.h>
#include <noatun/player.h>
#include <noatun/playlistsaver.h>

#include <kaction.h>
#include <kfiledialog.h>
#include <kfileitem.h>
#include <kfile.h>
#include <kiconloader.h>
#include <kpopupmenu.h>
#include <kpropertiesdialog.h>
#include <kstandardaction.h>
#include <kmessagebox.h>

SimpleMainWindow::SimpleMainWindow(SimplePlaylist *pl)
	: Noatun::NMainWindow(pl, false, false, 0, "SimpleMainWindow", Qt::WType_TopLevel),
	playlist(pl), mAddFilesDlg(0)
{
	setComponentData(playlist->componentData());
	setCaption(i18n("Playlist"));
	setIcon(SmallIcon("noatun_playlist"));

	mListView = new SimpleListView(playlist, this, "SimpleMainWindow::mListView");
	connect(mListView, SIGNAL(selectionChanged()), this, SLOT(slotUpdateActionStatus()));
	connect(mListView, SIGNAL(contextMenu(KListView*, QListViewItem*, const QPoint&)),
		this, SLOT(slotContextMenu(KListView*, QListViewItem*, const QPoint&)));

	setCentralWidget(mListView);

	// ACTIONS ======================
	new KAction(i18n("&Add Files..."), "add_file", Qt::CTRL + Qt::Key_Plus,
		this, SLOT(addFiles()), actionCollection(), "list_add_files");
	new KAction(i18n("Purge Files"), 0, 0,
		playlist, SLOT(purgeList()), actionCollection(), "list_purge");
	KStandardAction::close(this, SLOT(close()), actionCollection());


	new KAction("[Debug DB-Map]", 0, 0,
		playlist, SLOT(debugDbMap()), actionCollection(), "debug_dbmap");


	mPlayCurrent = new KAction(i18n("&Play"), "player_play", Qt::Key_Return,
		mListView, SLOT(executeCurrent()),  actionCollection(), "item_play");
	mDelete = new KAction(i18n("Delete"), "editdelete", Key_Delete,
		mListView, SLOT(deleteSelected()),  actionCollection(), "item_delete");
	mShowProperties = new KAction(i18n("P&roperties..."), "info", Qt::ALT+Qt::Key_Return,
		this, SLOT(slotShowProperties()), actionCollection(), "item_properties");

	actionCollection()->insert(mListView->viewColumnsAction());

	// ==============================

	setupGUI(Keys|Save|Create, "noatun_simpleplaylist.rc");

	slotUpdateActionStatus();
}

SimpleMainWindow::~SimpleMainWindow()
{
	actionCollection()->remove(mListView->viewColumnsAction());
}

SimpleListView *SimpleMainWindow::listView() const
{
	return mListView;
}

void SimpleMainWindow::addFiles()
{
	kDebug(66666) << k_funcinfo << endl;
	if (!mAddFilesDlg)
	{
		kDebug(66666) << k_funcinfo << "Creating new KFileDialog..." << endl;

		QStringList types = Noatun::PlaylistSaver::mimetypes() + playlist->global()->player()->mimeTypes();

		mAddFilesDlg = new KFileDialog(":mediadir",
			types.join(" "),
			0,
			0,
			false);

		mAddFilesDlg->setMode(KFile::Files | KFile::Directory);
		mAddFilesDlg->setCaption(i18n("Select File(s) to add"));

		connect(mAddFilesDlg, SIGNAL(okClicked()), this, SLOT(slotFilesSelected()));
		connect(mAddFilesDlg, SIGNAL(destroyed()), this, SLOT(slotAddFilesDlgDestroyed()));
	}
	mAddFilesDlg->show();
}

void SimpleMainWindow::slotFilesSelected()
{
	kDebug(66666) << k_funcinfo << endl;
	KURL::List fileList = mAddFilesDlg->selectedURLs();
	playlist->addFiles(fileList, -1, false);
}

void SimpleMainWindow::slotAddFilesDlgDestroyed()
{
	kDebug(66666) << k_funcinfo << endl;
	mAddFilesDlg = 0;
}

void SimpleMainWindow::slotUpdateActionStatus()
{
	bool on = (mListView->selectedItems().count() > 0);
	mPlayCurrent->setEnabled(on);
	mDelete->setEnabled(on);
	//mTrash->setEnabled(on);
	mShowProperties->setEnabled(on);
}

void SimpleMainWindow::slotShowProperties()
{
	KFileItemList files;
	files.setAutoDelete(true);
	KURL itemURL;
	QPtrList<QListViewItem> items(mListView->selectedItems());
	if (items.isEmpty())
		return;

	for (QPtrListIterator<QListViewItem> it(items); it.current(); ++it)
	{
		itemURL = static_cast<SimpleListViewItem *>(*it)->url();
		files.append(new KFileItem(KFileItem::Unknown, KFileItem::Unknown, itemURL));
	}

	if (KPropertiesDialog::canDisplay(files))
	{
		KPropertiesDialog::showDialog(files);
	}
	else
	{
		KMessageBox::sorry(this,
			i18np("Unable to read properties for selected item.",
				"Unable to read properties for %1 selected items.", items.count()));
	}
}

void SimpleMainWindow::slotContextMenu(KListView *, QListViewItem *lvi, const QPoint& p)
{
	if(lvi)
	{
		QPopupMenu *pop = dynamic_cast<QPopupMenu *>(factory()->container("listpopup", this));
		if(pop)
			pop->popup(p);
	}
}

#include "simplemainwindow.moc"
