#ifndef KJLOADER_H
#define KJLOADER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// local includes
#include "parser.h"

// noatun-specific includes
#include <noatun/plugin.h>
#include <noatun/nmainwindow.h>

// system includes
#include <qwidget.h>
#include <qbitmap.h>
#include <qptrlist.h>
#include <qcstring.h>

#include <kwinmodule.h>

using namespace Noatun;

class QLabel;
class KJWidget;
class KHelpMenu;
class KJSeeker;
class KJToolTip;
class KJFont;
class KJConfig;

class KJMainWindow : public NMainWindow, public Parser
{
Q_OBJECT

	friend class KJWidget;
public:
	KJMainWindow(Plugin *plug);
	~KJMainWindow();

public:
	void initGUI();
	void minimize();
	KHelpMenu *helpMenu() const { return mHelpMenu; }
	QStringList &item(const QString &key) { return *Parser::find(key); }

	// returns path to currently loaded configfile
	// can be either a newly loaded one or one of the three below
	QString currentSkin() { return mCurrentSkin; }

	// returns path to mainskin-configfile
	QString currentDefaultSkin() { return mCurrentDefaultSkin; }

	//returns path to dockmode-configfile if present
	QString currentDockModeSkin() { return mCurrentDockModeSkin; }

	//returns path to winshademode-configfile if present (not supported yet)
	QString currentWinshadeModeSkin() { return mCurrentWinshadeModeSkin; }

	QPtrList<KJWidget> widgetsAt(const QPoint &pt) const;

	void removeChild(KJWidget *c);
	void addChild(KJWidget *c);

	Plugin *plugin() const;
	KJConfig *prefs() const;

public Q_SLOTS:
	void loadSkin(const QString &file);
	void readConfig();
	void switchToDockmode();
	void returnFromDockmode();
	void timeUpdate();
	void newSong();

private Q_SLOTS:
	void loadSeeker();
	void slotWindowActivate(WId win);
	void slotWindowRemove(WId win);
	void slotWindowChange(WId win);
	void slotDesktopChange(int);
	void slotStackingChanged();
	void restack();
	void hideSplash();

private:
	void unloadSkin();
	void showSplash();

protected:
	virtual void mouseMoveEvent(QMouseEvent *e);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseReleaseEvent(QMouseEvent *e);
	virtual void paintEvent(QPaintEvent *e);
	virtual void wheelEvent(QWheelEvent *e);

	virtual void dragEnterEvent(QDragEnterEvent *event);
	virtual void dropEvent(QDropEvent *event);

public:
	static KJMainWindow* kjofol;

/*Q_SIGNALS:
	void closing();*/

private:
	// ==== docking stuff ====
	KWinModule *mWin;
	WId mDockToWin;
	int mDockPositionX, mDockPositionY, mDockPosition;
	QRect mDockWindowRect;
	// ==== end of docking stuff ====
	QPtrList<KJWidget> subwidgets;
	KJWidget *mClickedIn;
	KHelpMenu *mHelpMenu;
	KJFont *mText, *mNumbers, *mVolumeFont, *mPitchFont;
	QLabel *splashScreen;
	QString mCurrentSkin;
	QString mCurrentDefaultSkin;
	QString mCurrentDockModeSkin;
	QString mCurrentWinshadeModeSkin;

	KJConfig *mConfig;
	Plugin *mPlugin;
};



class KjofolPlugin : public Plugin, public FrontendInterface
{
	Q_OBJECT
	public:
		KjofolPlugin(const KComponentData &instance, Global *parent, const char* name);
		~KjofolPlugin();
		Interface *getInterface(const QString &iface);
		KMainWindow *mainWindow();
		virtual void init();
	private:
		KJMainWindow *mWin;
};



#endif // KJLOADER_H
