/* This file is part of Noatun

  Copyright 2001 by Neil Stevens <neil@qualityassistant.com>
  Copyright 2005 by Charles Samuels <charles@kde.org>
  Copyright 2005-2007 by Stefan Gehn <mETz81@web.de>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "noatun/stereobuttonaction.h"

namespace Noatun
{

StereoButtonAction::StereoButtonAction(QObject *parent) : KAction(parent)
{
}

StereoButtonAction::StereoButtonAction(const QString &text, QObject *parent) : KAction(text, parent)
{
}

StereoButtonAction::StereoButtonAction(const KIcon &icon, const QString &text, QObject *parent) : KAction(icon, text, parent)
{
}

void StereoButtonAction::disable()
{
	setEnabled(false);
}

void StereoButtonAction::enable()
{
	setEnabled(true);
}

void StereoButtonAction::toggleEnabled()
{
	setEnabled(!isEnabled());
}

} // END namespace Noatun
#include "stereobuttonaction.moc"
