/* This file is part of Noatun

  Copyright 2000-2006 by Charles Samuels <charles@kde.org>
  Copyright 2001-2007 by Stefan Gehn <mETz81@web.de>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "noatun/controls.h"

#include <qevent.h>
#include <qtoolbar.h>
//#include <kdebug.h>

namespace Noatun
{

L33tSlider::L33tSlider(QWidget * parent)
	: QSlider(Qt::Horizontal, parent), pressed(false)
{
}


L33tSlider::L33tSlider(Qt::Orientation o, QWidget * parent)
	: QSlider(o, parent), pressed(false)
{
}


bool L33tSlider::currentlyPressed() const
{
	return pressed;
}


void L33tSlider::setValue(int i)
{
	if (!pressed)
		QSlider::setValue(i);
}

void L33tSlider::keyPressEvent(QKeyEvent *e)
{
	QSlider::keyPressEvent(e);
	if (e->isAccepted())
		emit userChanged(value());
}

void L33tSlider::mousePressEvent(QMouseEvent *e)
{
	if (e->button() != Qt::RightButton)
		pressed = true;
	QSlider::mousePressEvent(e);
}


void L33tSlider::mouseReleaseEvent(QMouseEvent *e)
{
	if (e->button() != Qt::RightButton)
		pressed = false;
	QSlider::mouseReleaseEvent(e);
	if (e->isAccepted())
		emit userChanged(value());
}


void L33tSlider::wheelEvent(QWheelEvent *e)
{
	QSlider::wheelEvent(e);
	if (e->isAccepted())
		emit userChanged(value());
}


// ----------------------------------------------------------------------------

SliderAction::SliderAction(const QString& text, QObject* parent)
	: KAction(text, parent)
{
}

int SliderAction::value() const
{
	const QList<QWidget *> widgets = createdWidgets();
	if (widgets.isEmpty())
		return 0;
	L33tSlider *slider = qobject_cast<L33tSlider *>(widgets.first());
	if (!slider)
		return 0;
	return slider->value();
}

void SliderAction::setValue(int value)
{
	foreach(QWidget *w, createdWidgets())
	{
		if (L33tSlider *slider = qobject_cast<L33tSlider *>(w))
		{
			slider->setValue(value);
		}
	}
}


QWidget *SliderAction::createWidget(QWidget* _parent)
{
	QToolBar *parent = qobject_cast<QToolBar *>(_parent);
	if (!parent) // we only work in a toolbar
		return KAction::createWidget(_parent);

	//TODO: use text for label beside slider?

	L33tSlider *slider = new L33tSlider(Qt::Horizontal, parent);
	slider->setMinimumWidth(10);
	connect(slider, SIGNAL(userChanged(int)), SIGNAL(userChanged(int)));
	connect(slider, SIGNAL(sliderMoved(int)), SIGNAL(sliderMoved(int)));

	return slider;
}

} // namespace Noatun
#include "controls.moc"
