// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-

/***************************************************************************
 *   Copyright (C) 2004-2006 by Wilfried Huss                              *
 *   Wilfried.Huss@gmx.at                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/

#ifndef SMOOTHSCROLLVIEW_H
#define SMOOTHSCROLLVIEW_H

#include "ligature_export.h"

#include "dataView.h"

#include <QDateTime>
#include <Q3ScrollView>
#include <QTimer>

class LIGATURECORE_EXPORT SmoothScrollView: public Q3ScrollView, public DataView
{
  Q_OBJECT

public:
  SmoothScrollView(QWidget* parent = 0, const char* name = 0, Qt::WFlags f = 0);
  virtual ~SmoothScrollView();

  virtual void setupObservers(DataModel*);

public slots:
  virtual void setContentsPosSmooth(int x, int y);

protected:
  bool moveInProgress() { return viewportMoveActive; }

  /**
  @brief decides if the scrolling should be smooth or instentanious.

  @param scrollDistance the distance of the move in pixels

  @returns true if the scroll should be smooth.

  @note reimplement in a subclass if the default implementation does
        not give the optimal result.
  */
  virtual bool isSmoothScrollDistance(double scrollDistance);

private slots:
  void slotMoveViewport();

private:
  /** viewport move */
  bool viewportMoveActive;
  QTime viewportMoveTime;
  QPoint viewportMoveDest;
  QTimer viewportMoveTimer;
};

#endif
