// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-

/***************************************************************************
 *   Copyright (C) 2005 by Wilfried Huss                                   *
 *   Wilfried.Huss@gmx.at                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/

#ifndef RENDERQUEUE_H
#define RENDERQUEUE_H

#include <QObject>
#include <QEvent>
#include <QMutex>
#include <QList>
#include <QWaitCondition>

#include <renderedDocumentPagePixmap.h>
#include <pageNumber.h>

class RenderingFinishedEvent : public QEvent
{
public:
   RenderingFinishedEvent(RenderedDocumentPagePixmap* _page)
    : QEvent(QEvent::User), page(_page) {}

  RenderedDocumentPagePixmap* getPage() const { return page; }

private:
  RenderedDocumentPagePixmap* page;
};


class RenderQueue : public QObject
{
  Q_OBJECT

public:
  RenderQueue(QObject* parent);
  virtual ~RenderQueue();

  void clear();

  /* The next two functions are only called by the
     documentPageCache. */
  void addRenderJob(const JobId&);

  /* The next two functions are only called by the
     renderThread. */
  void addFinishedPage(RenderedDocumentPagePixmap*);
  JobId requestRenderJob();

  /** @brief Wait until a new rendering job is added to the queue.

      Calling this function from a thread, causes the thread to wait
      until a new item is added to the queue. Or alternativly the
      until the function @see wakeRenderThread has been called.

      @param m A mutex that must have been locked by the calling thread
               before the function has been called.

      @see addRenderJob
  */
  void waitForItems(QMutex* m);

  /** @brief wake all threads that were put to sleep by calling @see waitForItems */
  void wakeRenderThread();

private:
  void emitRenderingFinished(RenderedDocumentPagePixmap*);

private:
  QList<JobId> renderQueue;

  QWaitCondition itemAdded;

  QMutex mutex;
};

#endif
