// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
// KPrintDialogPage_PageOptions.cpp
//
// Part of LIGATURE - A framework for multipage text/gfx viewers
//
// (C) 2005 Stefan Kebekus
// Distributed under the GPL

#include <config.h>

#include "kprintDialogPage_pageoptions.h"
#include "kvs_debug.h"

#include <klocale.h>

#include <QFrame>
#include <QCheckBox>
#include <QToolTip>
#include <QVBoxLayout>


KPrintDialogPage_PageOptions::KPrintDialogPage_PageOptions(QWidget* parent, const char* /*name*/)
  : KPrintDialogPage(parent)
{
  setTitle( i18n("Page Size & Placement") );

  kprintDialogPage_pageoptions_baseLayout = 0;
  checkBox_center = 0;
  checkBox_rotate = 0;
  checkBox_shrink = 0;
  checkBox_expand = 0;

  kprintDialogPage_pageoptions_baseLayout = new QVBoxLayout(this);
  kprintDialogPage_pageoptions_baseLayout->setMargin(11);
  kprintDialogPage_pageoptions_baseLayout->setSpacing(6);

  checkBox_center = new QCheckBox(this);
  checkBox_center->setText( i18n( "Center the page on paper" ) );
  checkBox_center->setToolTip( i18n( "If this option is enabled, the pages are centered on the paper." ) );
  checkBox_center->setWhatsThis( i18n( "<qt><p>If this option is enabled, the pages will be printed centered on the paper; this makes "
                                            "more visually-appealing printouts.</p>"
                                            "<p>If the option is not enabled, all pages will be placed in the top-left corner of the paper.</p></qt>" ) );
  kprintDialogPage_pageoptions_baseLayout->addWidget( checkBox_center );

  checkBox_rotate = new QCheckBox(this);
  checkBox_rotate->setText( i18n( "Automatically choose landscape or portrait orientation" ) );
  checkBox_rotate->setToolTip( i18n( "If this option is enabled, some pages might be rotated to better fit the paper size." ) );
  checkBox_rotate->setWhatsThis( i18n( "<qt><p><qt><p>If this option is enabled, landscape or portrait orientation are automatically chosen on a "
                        "page-by-page basis. This makes better use of the paper and gives more visually-"
                                            "appealing printouts.</p>"
                                            "<p><b>Note:</b> This option overrides the Portrait/Landscape option chosen in the printer "
                                            "properties. If this option is enabled, and if the pages in your document have different sizes, "
                                            "then some pages might be rotated while others are not.</p></qt>" ) );
  kprintDialogPage_pageoptions_baseLayout->addWidget( checkBox_rotate );

  QFrame *line = new QFrame( this);
  line->setFrameShape( QFrame::HLine );
  line->setFrameShadow( QFrame::Sunken );
  line->setFrameShape( QFrame::HLine );
  kprintDialogPage_pageoptions_baseLayout->addWidget( line );

  checkBox_shrink = new QCheckBox(this);
  checkBox_shrink->setText( i18n( "Shrink oversized pages to fit paper size" ) );
  checkBox_shrink->setToolTip( i18n( "If this option is enabled, large pages that would not fit the printer's paper size will be shrunk." ) );
  checkBox_shrink->setWhatsThis( i18n( "<qt><p>If this option is enabled, large pages that would not fit the printer's paper size will be "
                                            "shrunk so that edges won't be cut off during printing.</p>"
                                            "<p><b>Note:</b> If this option is enabled, and if the pages in your document have different sizes, "
                                            "then different pages might be shrunk by different scaling factors.</p></qt>" ) );
  kprintDialogPage_pageoptions_baseLayout->addWidget( checkBox_shrink );

  checkBox_expand = new QCheckBox(this);
  checkBox_expand->setText( i18n( "Expand small pages to fit paper size" ) );
  checkBox_expand->setToolTip( i18n( "If this option is enabled, small pages will be enlarged so that they fit the printer's paper size." ) );
  checkBox_expand->setWhatsThis( i18n( "<qt><p>If this option is enabled, small pages will be enlarged so that they fit the printer's "
                                            "paper size.</p>"
                                            "<p><b>Note:</b> If this option is enabled, and if the pages in your document have different sizes, "
                                            "then different pages might be expanded by different scaling factors.</p></qt>" ) );
  kprintDialogPage_pageoptions_baseLayout->addWidget( checkBox_expand );

  resize( QSize(319, 166).expandedTo(minimumSizeHint()) );
#ifdef __GNUC__
#warning "TODO clearWState ???? KDE 4 ?"
#endif  
  //clearWState( WState_Polished );
}



void KPrintDialogPage_PageOptions::getOptions( QMap<QString,QString>& opts, bool incldef )
{
  // Save options, taking default values into consideration: by
  // default "center" is checked, "expand" and "shrink" are
  // not. Warning: The default values are also coded into setOptions()
  // and ligaturePluginGUI::print(..).

  if (checkBox_center != 0)
    if ( incldef || !checkBox_center->isChecked() )
      if (checkBox_center->isChecked())
        opts[ "kde-ligature-centerpage" ] = "true";
      else
        opts[ "kde-ligature-centerpage" ] = "false";

  if (checkBox_rotate != 0)
    if ( incldef || !checkBox_rotate->isChecked() )
      if (checkBox_rotate->isChecked())
        opts[ "kde-ligature-rotatepage" ] = "true";
      else
        opts[ "kde-ligature-rotatepage" ] = "false";

  if (checkBox_shrink != 0)
    if ( incldef || checkBox_shrink->isChecked() )
      if (checkBox_shrink->isChecked())
        opts[ "kde-ligature-shrinkpage" ] = "true";
      else
        opts[ "kde-ligature-shrinkpage" ] = "false";

  if (checkBox_expand != 0)
    if ( incldef || checkBox_expand->isChecked() )
      if (checkBox_expand->isChecked())
        opts[ "kde-ligature-expandpage" ] = "true";
      else
        opts[ "kde-ligature-expandpage" ] = "false";
}


void KPrintDialogPage_PageOptions::setOptions( const QMap<QString,QString>& opts )
{
  // Sets the centering option. By default, this option is
  // checked. Warning: All default values are also coded into
  // getOptions() and ligaturePluginGUI::print(..).
  QString op = opts[ "kde-ligature-centerpage" ];
  if (checkBox_center != 0)
    checkBox_center->setChecked( op != "false" );

  // same for rotation
  op = opts[ "kde-ligature-rotatepage" ];
  if (checkBox_rotate != 0)
    checkBox_rotate->setChecked( op != "false" );

  // Sets the shrink option. By default, this option is not checked
  op = opts[ "kde-ligature-shrinkpage" ];
  if (checkBox_shrink != 0)
    checkBox_shrink->setChecked( op == "true" );

  // Sets the expand option. By default, this option is not checked
  op = opts[ "kde-ligature-expandpage" ];
  if (checkBox_expand != 0)
    checkBox_expand->setChecked( op == "true" );
}


bool KPrintDialogPage_PageOptions::isValid( QString& )
{
  return true;
}
