// -*- C++ -*-

/***************************************************************************
 *   Copyright (C) 2003 by Stefan Kebekus                                  *
 *   kebekus@kde.org                                                       *
 *                                                                         *
 *   Copyright (C) 2005 by Wilfried Huss                                   *
 *   Wilfried.Huss@gmx.at                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/


#ifndef OPTION_DIALOG_PDF_WIDGET_H
#define OPTION_DIALOG_PDF_WIDGET_H

#include "ui_optionDialogPdfWidget_base.h"

class OptionDialogPdfWidget_base : public QWidget, public Ui::OptionDialogPdfWidget_base
{
public:
  OptionDialogPdfWidget_base( QWidget *parent ) : QWidget( parent ) {
    setupUi( this );
  }
};

class OptionDialogPdfWidget : public OptionDialogPdfWidget_base
{
 Q_OBJECT

 public:
  OptionDialogPdfWidget(QWidget* parent = 0);
  ~OptionDialogPdfWidget();

 public slots:
  void apply();
  void slotComboBox(int item);
  void slotUserDefdEditorCommand(const QString& text);
  void slotExtraHelpButton(const QString& anchor);

 private:
  QStringList editorNameString, editorCommandString, editorDescriptionString;
  QString     EditorCommand;
  bool        isUserDefdEditor;
  QString     usersEditorCommand;
};

#endif
