/***************************************************************************
 *  This file is part of the KDE libraries                                 *
 *  Copyright (c) 2005 Helge Deller <deller@kde.org>                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef FAX_PRINTSETTINGS_H
#define FAX_PRINTSETTINGS_H

#include <kdeprint/kprintdialogpage.h>

#define FAX_SCALE_FULLPAGE "fax-scalefullpage"
#define FAX_CENTER_HORZ    "fax-center-horz"
#define FAX_CENTER_VERT    "fax-center-vert"

class QCheckBox;

class FaxPrintSettings : public KPrintDialogPage
{
Q_OBJECT

public:
  FaxPrintSettings(QWidget* parent = 0);
  ~FaxPrintSettings();

  void getOptions(QMap<QString, QString>& opts, bool incldef = false);
  void setOptions(const QMap<QString, QString>& opts);

private:
  QCheckBox* m_scaleFullPage;
  QCheckBox* m_center_horz;
  QCheckBox* m_center_vert;
};

#endif
