#include "wizard.h"
#include "wizard.moc"

#include <sys/types.h>
#include <netinet/in.h>


#include <QRadioButton>
#include <QSignalMapper>

#include <QFile>
#include <QLabel>
#include <QVBoxLayout>

#include <klocale.h>
#include <kdialog.h>
#include <kbuttongroup.h>

#include "types.h"
#include "defines.h"
#include "socket.h"

#include <kserversocket.h>
#include <kglobal.h>
#include <kconfiggroup.h>

#ifdef __bsdi__
#define IPPORT_USERRESERVED IPPORT_DYNAMIC
#endif
#ifndef IPPORT_USERRESERVED
#define IPPORT_USERRESERVED IPPORT_RESERVED
#endif
#define MIN_USER_PORT (unsigned short int)IPPORT_USERRESERVED
#define MAX_USER_PORT 65535

MPWizard::MPWizard(const MPGameInfo &gi, ConnectionData &_cd,
				   QWidget *parent, const char *name)
: K3Wizard(parent, name, true), cd(_cd)
{
//	setupTypePage(); // #### REMOVE NETWORK GAMES UNTIL FIXED
    type = Local;
	setupLocalPage(gi);
}

//-----------------------------------------------------------------------------
void MPWizard::setupTypePage()
{
    KConfigGroup cg(KGlobal::config(), MP_GROUP);

	typePage = new KVBox(this);
	typePage->setMargin(KDialog::marginHint());

	KButtonGroup *vbg = new KButtonGroup(typePage);
        QVBoxLayout *vbox = new QVBoxLayout(vbg);
	connect(vbg, SIGNAL(clicked(int)), SLOT(typeChanged(int)));
	QRadioButton *b;
	b = new QRadioButton(i18n("Create a local game"), vbg);
        vbox->addWidget(b);
	b = new QRadioButton(i18n("Create a network game"), vbg);
        vbox->addWidget(b);
	b = new QRadioButton(i18n("Join a network game"), vbg);
        vbox->addWidget(b);
	type = (Type)cg.readEntry(MP_GAMETYPE, 0);
	if ( type<0 || type>2 ) type = Local;
	vbg->setSelected(type);

	typePage->setSpacing(KDialog::spacingHint());
	net = new QGroupBox(i18n("Network Settings"), typePage);
        QGridLayout *glay = new QGridLayout(net);
	glay->setSpacing(KDialog::spacingHint());
	lserver = new QLabel(" ", net);
        glay->addWidget(lserver, 0, 0);
	eserver = new QLineEdit(net);
        glay->addWidget(eserver, 0, 1);
	glay->addWidget(new QLabel(i18n("Port:"), net), 1, 0);
	int p = cg.readEntry(MP_PORT, (uint)MIN_USER_PORT);
	eport = new KIntNumInput(p, net);
        glay->addWidget(eport, 1, 1);
        eport->setRange(MIN_USER_PORT, MAX_USER_PORT, 1, false);

	addPage(typePage, i18n("Choose Game Type"));
	setHelpEnabled(typePage, false);
	typeChanged(type);
}

//-----------------------------------------------------------------------------
void MPWizard::setupLocalPage(const MPGameInfo &gi)
{
	localPage = new KVBox(this);
	localPage->setMargin(KDialog::marginHint());

	wl = new WidgetList<PlayerLine>(5, localPage);
	QSignalMapper *husm = new QSignalMapper(this);
	if (gi.humanSettingSlot) connect(husm, SIGNAL(mapped(int)),
									 gi.humanSettingSlot);
	QSignalMapper *aism = new QSignalMapper(this);
	if (gi.AISettingSlot) connect(aism, SIGNAL(mapped(int)), gi.AISettingSlot);

        KConfigGroup cg(KGlobal::config(), MP_GROUP);
	QString n;
	PlayerComboBox::Type type;
	PlayerLine *pl;
	Q_ASSERT( gi.maxNbLocalPlayers>0 );
	for (uint i=0; i<gi.maxNbLocalPlayers; i++) {
		type = (PlayerComboBox::Type)
			cg.readEntry(QString(MP_PLAYER_TYPE).arg(i),
   			            int(i==0 ? PlayerComboBox::Human : PlayerComboBox::None));
		n = cg.readEntry(QString(MP_PLAYER_NAME).arg(i),
                             i18n("Player #%1", i));

		pl = new PlayerLine(type, n, gi.humanSettingSlot, gi.AISettingSlot,
							i!=0, gi.AIAllowed, wl);
		connect(pl, SIGNAL(typeChanged(int)), SLOT(lineTypeChanged(int)));
		husm->setMapping(pl, i);
		connect(pl, SIGNAL(setHuman()), husm, SLOT(map()));
		aism->setMapping(pl, i);
		connect(pl, SIGNAL(setAI()), aism, SLOT(map()));
		wl->append(pl);
	}

	((KVBox *)localPage)->setSpacing(KDialog::spacingHint());

//	keys = new QPushButton(i18n("Configure Keys..."), localPage);
//	connect(keys, SIGNAL(clicked()), SLOT(configureKeysSlot()));

	addPage(localPage, i18n("Local Player's Settings"));
	setHelpEnabled(localPage, false);
	lineTypeChanged(0);
}

QString MPWizard::name(uint i) const
{
	QString s = wl->widget(i)->name();
	if ( s.length()==0 ) s = i18n("Player #%1", i);
	return s;
}

void MPWizard::typeChanged(int t)
{
	type = (Type)t;

	QString str;
	if ( type!=Client ) {
		str = "localhost";
		lserver->setText(i18n("Hostname:"));
	} else {
        KConfigGroup cg(KGlobal::config(), MP_GROUP);
		str = cg.readEntry(MP_SERVER_ADDRESS,
                               i18n("the.server.address"));
		lserver->setText(i18n("Server address:"));
	}
	eserver->setText(str);
	eserver->setEnabled(type==Client);
	eport->setEnabled(type!=Local);
	net->setEnabled(type!=Local);
}

void MPWizard::lineTypeChanged(int)
{
	bool b = false;
	for (uint i=0; i<wl->size(); i++)
		if ( wl->widget(i)->type()==PlayerComboBox::Human ) {
			b = true;
			break;
		}
//	keys->setEnabled(b);
}

void MPWizard::accept()
{
    KConfigGroup cg(KGlobal::config(), MP_GROUP);

	cd.network         = ( type!=Local );
	cd.server          = ( type!=Client );

	if (cd.network) {
        //**********************************************************
        // create socket
        QString host = QFile::encodeName(eserver->text());
	if (cd.server)
	{
		KNetwork::KServerSocket *socket = new KNetwork::KServerSocket(host, QString::number(eport->value()));
		// do lookup
		bool res = socket->lookup();
		if ( checkSocket(res, socket, i18n("Error looking up for \"%1\"", host), this) ) {
			delete socket;
			return;
		}
		socket->listen();
		if ( checkSocket(res, socket, i18n("Error opening socket"), this) ) {
			delete socket;
			return;
		}
		cd.rhd.socket = new Socket(socket, true);
	}
	else
	{
		KNetwork::KStreamSocket *socket = new KNetwork::KStreamSocket(host, QString::number(eport->value()));
		// do lookup
		bool res = socket->lookup();
		if ( checkSocket(res, socket, i18n("Error looking up for \"%1\"", host), this) ) {
			delete socket;
			return;
		}
		res = socket->connect();
		if ( checkSocket(res, socket, i18n("Error opening socket"), this) ) {
			delete socket;
			return;
		}
		cd.rhd.socket = new Socket(socket, true);
	}

		if ( !cd.server )
            cg.writeEntry(MP_SERVER_ADDRESS, eserver->text());
		cg.writeEntry(MP_PORT, eport->value());
	}

    BoardData bd;
	for (uint i=0; i<wl->size(); i++) {
		if ( wl->widget(i)->type()==PlayerComboBox::None ) continue;
		bd.name = name(i);
		bd.type = wl->widget(i)->type();
		cd.rhd.bds += bd;
	}

	cg.writeEntry(MP_GAMETYPE, (int)type);
	for (uint i=0; i<wl->size(); i++) {
		cg.writeEntry(QString(MP_PLAYER_TYPE).arg(i),
						  (int)wl->widget(i)->type());
		cg.writeEntry(QString(MP_PLAYER_NAME).arg(i), name(i));
	}

	K3Wizard::accept();
}

void MPWizard::showPage(QWidget *page)
{
	if ( page==localPage ) setFinishEnabled(localPage, true);
	K3Wizard::showPage(page);
}

void MPWizard::configureKeysSlot()
{
	uint nb = 0;
	for (uint i=0; i<wl->size(); i++)
		if ( wl->widget(i)->type()==PlayerComboBox::Human ) nb++;
	emit configureKeys(nb);
}
