#ifndef COMMON_MISC_UI_H
#define COMMON_MISC_UI_H

#include <libksirtet_export.h>
#include <QVector>
#include <kgameprogress.h>
#include <khbox.h>

#include "base/baseboard.h"

/*****************************************************************************/
class ShowNextPiece : public QGraphicsView, public Zoomable
{
 Q_OBJECT
 public:
    ShowNextPiece(BaseBoard *, QWidget *parent);
    virtual QSize sizeHint() const;
    virtual void zoomChanged();
};

/*****************************************************************************/
class Shadow : public QWidget, public Zoomable
{
 Q_OBJECT
 public:
    Shadow(BaseBoard *, QWidget *parent);

    virtual QSize sizeHint() const;
    virtual QSizePolicy sizePolicy() const;
    void setDisplay(bool show);
    virtual void zoomChanged();

 private:
    int              _xOffset;
    const BaseBoard *_board;
    bool             _show;

    void paintEvent(QPaintEvent *);
};

/*****************************************************************************/
class Led;

class KSIRTETLIB_EXPORT GiftPool : public KHBox
{
 Q_OBJECT
 public:
    GiftPool(QWidget *parent);

    virtual QSize sizeHint() const;
    virtual QSizePolicy sizePolicy() const;

    void reset();
	void put(uint);
	uint take();
	bool pending() const { return ready; }

 private slots:
    void timeout() { ready = true; }

 private:
	QVector<Led*> leds;
	uint         _timeout, nb;
	bool         ready;
};


/*****************************************************************************/
class PlayerProgress : public KGameProgress, public Zoomable
{
  Q_OBJECT
public:
  PlayerProgress(BaseBoard *board, QWidget *parent = 0);
  
  virtual QSize sizeHint() const;
  virtual QSizePolicy sizePolicy() const;
  virtual void zoomChanged();
  
private:
  BaseBoard *_board;
};

#endif
