#include "common_factory.h"

#include "ai.h"
#include "game_config.h"


CommonFactory::CommonFactory(const MainData &md, const BaseBoardInfo &bbi,
                             const CommonBoardInfo &ci)
    : BaseFactory(md, bbi), cbi(ci)
{}

QWidget *CommonFactory::createAppearanceConfig()
{
    return new AppearanceConfig;
}

QWidget *CommonFactory::createGameConfig()
{
    return new GameConfig;
}

QWidget *CommonFactory::createAIConfig()
{
    AI *ai = createAI();
    QWidget *cw = new AIConfig(ai->elements());
    delete ai;
    return cw;
}
