/**
 * Copyright Michel Filippi <mfilippi@sade.rhein-main.de>
 *           Robert Williams
 *           Andrew Chant <andrew.chant@utoronto.ca>
 *           André Luiz dos Santos <andre@netvision.com.br>
 * Copyright (C) 2004-2005 Benjamin C. Meyer <ben at meyerhome dot net>
 *
 * This file is part of the ksnake package
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#include "startroom.h"

#include <QLabel>
#include <QMatrix>
#include <QSpinBox>
#include <klocale.h>
#include <QGridLayout>
#include <QHBoxLayout>

#include "levels.h"

StartRoom::StartRoom( QWidget *parent )
    : QWidget( parent )
{
    QGridLayout *Form1Layout = new QGridLayout( this );
    Form1Layout->setMargin(11);
    Form1Layout->setSpacing(6);
    QSpacerItem* spacer = new QSpacerItem( 20, 61, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Form1Layout->addItem( spacer, 2, 1 );

    QHBoxLayout *layout1 = new QHBoxLayout;
    layout1->setMargin( 0 );
    layout1->setSpacing( 6 );
    QSpacerItem* spacer_2 = new QSpacerItem( 91, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout1->addItem( spacer_2 );

    picture = new QLabel( this );
    picture->setObjectName( "picture" );
    layout1->addWidget( picture );
    QSpacerItem* spacer_3 = new QSpacerItem( 41, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout1->addItem( spacer_3 );

    Form1Layout->addLayout( layout1, 0, 0, 1, 2 );

    roomRange = new QSpinBox( this );
    roomRange->setObjectName( "kcfg_StartingRoom" );
    roomRange->setRange( 1, 25 );

    Form1Layout->addWidget( roomRange, 1, 1 );

    QLabel *textLabel = new QLabel( this );
    textLabel->setObjectName( "textLabel" );
    textLabel->setText(i18n("First level:"));
    Form1Layout->addWidget( textLabel, 1, 0 );

    connect( roomRange, SIGNAL(valueChanged(int)), SLOT(loadLevel(int)));
    loadLevel(1);
}

void StartRoom::loadLevel(int level)
{
	if(level < 1 || level > leV->max())
		return;

	QPixmap pixmap = leV->getPixmap(level);
	QMatrix m;
	m.scale( (double)7, (double)7 );
	pixmap = pixmap.transformed( m );
	picture->setPixmap(pixmap);
}

#include "startroom.moc"

