/*
  Copyright (C) 2006 Daren Sawkey
  daren@sawkey.net

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  $Id: kbgofflinecalc.h 2006-11-30 03:51:57Z darens $

*/

#ifndef __KBGOFFLINECALC_H
#define __KBGOFFLINECALC_H
		
#include <vector>
#include "kbgboard.h"

class KMainWindow;
class KBgEngineOfflinePrivate;

struct Move {
	int startPoint;
	int dieValue;
	bool kicked;
};

struct moveScore {
	std::vector<Move> moves;
	float score;
};

/* Labelling convention (computer engine)
	players are 0 and 1
	points on board are 1 (top right) counterclockwise to 24 (bottom right)
	home is 1-6 for player 0, 19-24 for player 1
	delta = endpoint - startpoint < 0 for player 0
				  > 0 for player 1
	define activePlayerSign() = -1 for player 0, +1 for player 1 (same sign as delta)
	PointCount[i] is < 0 for player 0's checkers, >0 for player 1's checkers
	home board is 0 for player 0, 25 for player 1   ( ie 25 * activePlayer )
	bar is 31 for player 0, 32 for player 1  ( ie 31 + activePlayer ) [ using 31,32 helps with bookkeeping ]
 */
class KBgEngineOfflineCalc
{
public:
	
	KBgEngineOfflineCalc( KMainWindow * parent = 0, QMenu * pmenu = 0 );
	~KBgEngineOfflineCalc();
			
	QString getComputerMove( KBgStatus &game );
	// return value 0: decline, 1: accept, 2: redouble
	int getDouble( KBgStatus &game );
	
private:

	/**
	 * helper functions used to calculate computer's move
	 */
	int convertGame( KBgStatus &game, int *points, std::vector<int> &dice );

	void computeMove( int *points, std::vector<int> &dice, std::vector<moveScore> &movesList, int p );
	void pushMove( int *newPoints, std::vector<Move> &move, std::vector<moveScore> &list, int p );
	float pointsScore( int *points, int p );
	bool isValidSingleMove( int *points, Move move, int p );
	bool isValidTotalMove( int *startpoints, std::vector<Move> &move, std::vector<int> &dice,int p );
	bool movePossible( int *points, std::vector<int> &dice, int p );
	int updateTemps( int *oldPoints, int *newPoints, std::vector<int> &oldDice, std::vector<int> &newDice, int startPoint, std::vector<int>::iterator &die, int p );
	void checkMove( int *oldPoints, int *newPoints, std::vector<int> &oldDice, std::vector<int> &newDice, std::vector<Move> &oldMove, std::vector<Move> &newMove, int p );
	int endp( int sp, int dv );

	/*
	 * variables
	 */
	unsigned int m_moves;
	KBgStatus *g;
};

#endif // __KBGOFFLINECALC_H
