/***************************************************************************
                        kanimator.h  -  description
                           -------------------
  begin                : Wed Aug 02 2006
  copyright            : (C) 2006 by David Saxton
  email                : david@bluehaze.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KANIMATION_H
#define KANIMATION_H

#include <QGraphicsPixmapItem>

class QString;
class QGraphicsScene;

/**
 * This class contains information about one frame.
 */
class KFrame
{
    public:
		/**
		 * The constructor gets:
		 * @param nx the position x coordinate
		 * @param ny the position  coordinate
		 * @param picture the picture number (this is which image to use, not
		 * the order of the frame in sequence).
		*/
		KFrame( double nx, double ny, int np );
	
		double x, y; // position
		int picture; // frame number
};


/**
 * KStoryBoard
 */
class KAnimation : public QGraphicsPixmapItem
{
    public:
		/**
		 * \a fileName is the name of the file containing the animation story.
		 * \a dataFileNamePattern is the pattern of the file name (see
		 * Q3CanvasPixmapArray constructor).
		 * \a scene Pointer to the QGraphicsScene
		 */
		KAnimation( const QString & fileName, const QString & dataFileNamePattern, QGraphicsScene * scene );
		~KAnimation();
		
		/**
		 * Resets the animation back to the first frame.
		 */
		void setToStart();

	private:
		virtual void advance( int phase );
		/**
		 * Loads the frames
		 */
		void loadFrames( const QString & fileName );
		/**
		 * Loads the pictures.
		 */
		void loadPictures( const QString & fileNamePattern );
		/**
		 * Updates our parent QGraphicsPixmapItem from m_currentFrame.
		 */
		void updateAnimation();
		
		QList<KFrame> m_animation;
		/**
		 * Map between the picture numbers and the pictures.
		 */
		QMap<int, QPixmap> m_pictures;
		/**
		 * Endlessly loop the animation or not?
		 */
		bool m_repeat;
		/**
		 * Which frame are we at?
		 */
		int m_currentFrame;
		/**
		 * Which picture (from m_pictures) have we currently loaded into our
		 * QGraphicsPixmapItem parent?
		 */
		int m_currentPicture;
};

#endif
