/***************************************************************************
                        kanimator.cpp  -  description
                           -------------------
  begin                : Wed Aug 02 2006
  copyright            : (C) 2006 by David Saxton
  email                : david@bluehaze.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kanimation.h"

#include <kdebug.h>

#include <QFile>
#include <QTextStream>
#include <QtGlobal>

//BEGIN class KFrame
KFrame::KFrame( double nx, double ny, int np )
{
	x = nx;
	y = ny;
	picture = np;
}
//END class KFrame



//BEGIN class KAnimation
KAnimation::KAnimation( const QString & fileName, const QString & dataFileNamePattern, QGraphicsScene * scene )
	: QGraphicsPixmapItem( 0, scene )
{
	m_currentPicture = -1;
	m_currentFrame = -1;
	m_repeat = false;
	
	loadFrames( fileName );
	loadPictures( dataFileNamePattern );
}


KAnimation::~KAnimation()
{
}


void KAnimation::loadFrames( const QString & fileName )
{
	QFile f( fileName );

	if ( !f.open( QIODevice::ReadOnly ) )
	{
		kDebug() << k_funcinfo << "Could not open file, filename="<<fileName<<endl;
		return;
	}
	kDebug() << "loading the story board..." << endl;
	
	QTextStream t( &f );        // use a text stream
	while ( !t.atEnd() )               // until end of file...
	{
		QString s = t.readLine();       // line of text excluding '\n'
		QString dbgString = s;
		int pos = s.indexOf ( "#");
		if (pos==-1)
			pos = s.indexOf ( ";");
		if ( pos > -1 )
		{
			dbgString = s.mid( pos +1 );
			kDebug() << "Comment: " << dbgString << endl;
			s = s.left( pos );
		}
		if ( s.isEmpty() )
			continue;
			
		QString command_word = s.section( " ", 0, 0 );
			
		// new frame
		if ( command_word == "move" )
		{
			QString parameters = s.section( " ", 1, 1 );
			KFrame frame(parameters.section( ",", 0, 0 ).toDouble(),
						 parameters.section( ",", 1, 1 ).toDouble(),
						 parameters.section( ",", 2, 2 ).toInt() );
			m_animation << frame;		
			
			kDebug() << parameters << endl;	
		}
		else if ( command_word == "repeat" )
		{
			m_repeat = true;
		}
		else
		{
			kWarning() << k_funcinfo << "Unknown command word: "<< command_word<<endl;
		}
	}
	
	f.close();
}


void KAnimation::loadPictures( const QString & fileNamePattern )
{
	foreach ( const KFrame &frame, m_animation )
	{
		if ( m_pictures.contains( frame.picture ) )
			continue;
		
		QString fileName = fileNamePattern.arg( frame.picture, 4, 10, QChar('0') );
		m_pictures[ frame.picture ] = QPixmap(fileName);
	}
}


void KAnimation::setToStart()
{
	m_currentFrame = 0;
	updateAnimation();
}


void KAnimation::advance( int phase )
{
	if ( phase == 0 )
	{
		// Whether we return on phase 0 or 1 is arbitrary, just as long
		// as we return on one of them
		return;
	}
	
	m_currentFrame++;
	if ( m_repeat )
		m_currentFrame %= m_animation.size();
	else if ( m_currentFrame >= m_animation.size() )
		m_currentFrame = m_animation.size() - 1;
	
	updateAnimation();
}


void KAnimation::updateAnimation()
{
	KFrame frame = m_animation[m_currentFrame];
	
	if ( m_currentPicture != frame.picture )
	{
		m_currentPicture = frame.picture;
		setPixmap( m_pictures[ m_currentPicture ] );
	}
	
	setPos( frame.x, frame.y );
}
//END class KAnimation

