/* This file is part of the KDE project
   Copyright (C) 2002 Anders Lund <anders.lund@lund.tdcadsl.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "katemailfilesdialog.h"
#include "katemainwindow.h"
#include "kateviewmanager.h"
#include "katedocmanager.h"

#include <klocale.h>
#include <kurl.h>

#include <QEvent>
#include <QLabel>
#include <QStringList>
#include <kvbox.h>
//Added by qt3to4:
#include <QList>

/* a private check list item, that can store a KTextEditor::Document*.  */
class KateMailDocItem : public QTreeWidgetItem {
  public:
    KateMailDocItem( QTreeWidget *parent, KTextEditor::Document *doc )
      : QTreeWidgetItem( parent ), mdoc(doc)
    {
      setText(0, doc->documentName());
      setText(1, doc->url().prettyUrl());
      setCheckState(0, Qt::Unchecked);
    };
    KTextEditor::Document *doc() { return mdoc; };
  private:
    KTextEditor::Document *mdoc;
};

///////////////////////////////////////////////////////////////////////////
// KateMailDialog implementation
///////////////////////////////////////////////////////////////////////////
KateMailDialog::KateMailDialog( QWidget *parent, KateMainWindow  *mainwin )
  : KDialog( parent ),
    mainWindow( mainwin )
{
  setCaption( i18n("Email Files") );
  setButtons( Ok | Cancel| User1 );
  setButtonGuiItem( User1, KGuiItem( i18n("&Show All Documents >>") ) );
  setObjectName( "kate mail dialog" );
  setModal( true );

  setButtonGuiItem( KDialog::Ok, KGuiItem( i18n("&Mail..."), "mail_send") );

  mw = new KVBox(this);
  setMainWidget(mw);
  mw->installEventFilter( this );

  lInfo = new QLabel( i18n(
        "<p>Press <strong>Mail...</strong> to email the current document."
        "<p>To select more documents to send, press <strong>Show All Documents&nbsp;&gt;&gt;</strong>."), mw );
  // TODO avoid untill needed - later
  list = new QTreeWidget( mw );
  QStringList header;
  header << i18n("Name");
  header << i18n("URL");
  list->setHeaderLabels(header);
  
  KTextEditor::Document *currentDoc = mainWindow->viewManager()->activeView()->document();
  uint n = KateDocManager::self()->documents();
  uint i = 0;
  QTreeWidgetItem *item;
  while ( i < n ) {
    KTextEditor::Document *doc = KateDocManager::self()->document( i );
    if ( doc ) {
      item = new KateMailDocItem( list, doc );
      if ( doc == currentDoc ) {
        list->setCurrentItem(item);
        item->setCheckState(0, Qt::Checked);
      }
    }
    i++;
  }
  list->hide();
  connect( this, SIGNAL(user1Clicked()), this, SLOT(slotShowButton()) );
  mw->setMinimumSize( lInfo->sizeHint() );
}

QList<KTextEditor::Document *> KateMailDialog::selectedDocs()
{
  QList<KTextEditor::Document *> l;
  KateMailDocItem *item = NULL;
  for(int i = 0; i < list->topLevelItemCount(); i++)
  {
    item = (KateMailDocItem *)list->topLevelItem(i);
    if ( item->checkState(0) == Qt::Checked )
      l.append( item->doc() );
  }
  return l;
}

void KateMailDialog::slotShowButton()
{
  if ( list->isVisible() ) {
    setButtonText( User1, i18n("&Show All Documents >>") );
    list->hide();
    mw->setMinimumSize( QSize( lInfo->sizeHint().width(), lInfo->sizeHint().height()) );
    setMinimumSize( mw->width(), sizeHint().height() - list->sizeHint().height());
  }
  else {
    list->show();
    setButtonText( User1, i18n("&Hide Document List <<") );
    lInfo->setText( i18n("Press <strong>Mail...</strong> to send selected documents") );
    mw->setMinimumSize( QSize( lInfo->sizeHint().width(), list->sizeHint().height() + lInfo->sizeHint().height()) );
    setMinimumSize( mw->width(), sizeHint().height());
  }

  resize( width(), minimumHeight() );
}
#include "katemailfilesdialog.moc"

// kate: space-indent on; indent-width 2; replace-tabs on;
