/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/

#include "options.h"

#include "kpackage.h"
#include "managementWidget.h"
#include "pkgInterface.h"

#include <kvbox.h>
#include <QtGui/QCheckBox>
#include <QtGui/QVBoxLayout>
#include <klocale.h>
#include <kdebug.h>
#include <kurlrequester.h>
#include <QtGui/QLabel>
#include <Qt3Support/Q3GroupBox>
#include <QtGui/QLayout>
#include <QtGui/QLineEdit>
#include <Qt3Support/Q3ButtonGroup>
#include <QtGui/QRadioButton>
#include <Qt3Support/Q3TabDialog>
#include <kcombobox.h>
#include <klineedit.h>

#include <findf.h>
#include <kglobal.h>
#include <kpagedialog.h>

extern Opts *opts;
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
Options::Options(QWidget *parent)
    : KPageDialog(parent){
    setFaceType( KPageDialog::Tabbed );
    setCaption(  i18n("Options") );
    setButtons( Ok | Cancel );
    setDefaultButton( Ok );
    setModal( false );

    fRemote = false;

    DCache = dc = opts->DCache;
    PCache = pc = opts->PCache;
    privCmd = prc = opts->privCmd;

 
    {
      KVBox *page = new KVBox(this);
      addPage( page,i18n("&Types") );
      framet = new Q3GroupBox(1,Qt::Horizontal,i18n("Handle Package Type"), page);

      hh =  new Q3GroupBox(1,Qt::Horizontal,i18n("Remote Host"),framet);
      huse = new QCheckBox(i18n("Use remote host (Debian APT only):"),hh);
      connect(huse,  SIGNAL(clicked()), this, SLOT(useRemote()));
      hosts = new KComboBox( true, hh );
      hosts->setObjectName( "combo" );
      KCompletion *comp = hosts->completionObject();
      connect(hosts,SIGNAL(returnPressed(const QString&)),comp,SLOT(addItem(const QString&)));
      connect(hosts,SIGNAL(returnPressed()),this,SLOT(insHosts()));
      hosts->setMaxCount(20);
      hosts->setDuplicatesEnabled(false);
      hosts->setInsertPolicy(QComboBox::AtTop);
      //      hosts->setInsertionPolicy(QComboBox::NoInsertion);
      hosts->setTrapReturnKey(true);

      QString msgStr;
//      if (kpinterface->hasProgram) {
//	 msgStr = "";
//      } else {
//	 msgStr = i18n("%1 not found",
//	       kpinterface->errExe);
//      }
      packageBox = new Q3GroupBox(2,Qt::Horizontal,msgStr, framet, "box");
      packageHandle =  new QCheckBox(i18n("Enable"), packageBox);
      connect(packageHandle, SIGNAL(clicked()), this, SLOT(scanLocates()));
      locate = new QPushButton(i18n("Location of Packages"),packageBox);
    }

    {
        KVBox *page = new KVBox(this );
        addPage( page, i18n("Cac&he"));

      bc = new Q3ButtonGroup(page);
      bc->setTitle(i18n("Cache Remote Package Folders"));
      connect( bc, SIGNAL(clicked(int)), SLOT(PDCache(int)) );

      QVBoxLayout* vc = new QVBoxLayout( bc );
      vc->setSpacing( KDialog::spacingHint() );
      vc->setMargin( KDialog::marginHint() );
      vc->setObjectName( "vc" );
      vc->addSpacing( bc->fontMetrics().height() );

      dcache[0] = new QRadioButton(i18n("Always"),bc);
      vc->addWidget(dcache[0]);

      dcache[1] = new QRadioButton(i18n("During a session"),bc);
      vc->addWidget(dcache[1]);

      dcache[2] = new QRadioButton(i18n("Never"),bc);
      vc->addWidget(dcache[2]);
	bc->setExclusive (true);

      bp = new Q3ButtonGroup(page);
      bp->setTitle(i18n("Cache Remote Package Files"));
      connect( bp, SIGNAL(clicked(int)), SLOT(PPCache(int)) );

      QVBoxLayout* vp = new QVBoxLayout( bp );
      vp->setSpacing( KDialog::spacingHint() );
      vp->setMargin( KDialog::marginHint() );
      vp->setObjectName( "vp" );
      vp->addSpacing( bp->fontMetrics().height() );

      pcache[0] = new QRadioButton(i18n("Always"),bp);
      vp->addWidget(pcache[0]);

      pcache[1] = new QRadioButton(i18n("During a session"),bp);
      vp->addWidget(pcache[1]);

      pcache[2] = new QRadioButton(i18n("Never"),bp);
      vp->addWidget(pcache[2]);
	bp->setExclusive(true);
      Q3GroupBox* cd = new Q3GroupBox (1, Qt::Horizontal, i18n("Cache Folder"), page) ;
      cd->setSizePolicy (QSizePolicy::Expanding, QSizePolicy::Fixed) ;

      cachedir = new KUrlRequester(KUrl(""), cd/*, "cachedir"*/);
    }

    {
      QWidget *page = new QWidget(this );
      addPage( page, i18n("&Misc"));
      QVBoxLayout *vf = new QVBoxLayout(page);

      //      vf->setSpacing(KDialog::spacingHint());
      vf->setMargin(0);

      bs = new Q3ButtonGroup(page);
      bs->setTitle(i18n("Execute Privileged Commands Using"));
      connect( bs, SIGNAL(clicked(int)), SLOT(PPrivs(int)) );

      QVBoxLayout* vs = new QVBoxLayout( bs );
      vs->setSpacing( KDialog::spacingHint() );
      vs->setMargin( KDialog::marginHint() );
      vs->setObjectName( "vs" );
      vs->addSpacing( bs->fontMetrics().height() );

      privs[0] = new QRadioButton(i18n("su command"),bs);
      vs->addWidget(privs[0]);

      privs[1] = new QRadioButton(i18n("sudo command"),bs);
      vs->addWidget(privs[1]);

      privs[2] = new QRadioButton(i18n("ssh command"),bs);
      vs->addWidget(privs[2]);

     bs->setExclusive(true);
      valid = new QCheckBox(i18n("Verify file list"), page);
      valid->setObjectName("valid");
      vf->addWidget(valid,0,Qt::AlignLeft);

      pkgRead = new QCheckBox(i18n("Read information from all local package files"), page);
      pkgRead->setObjectName("pkgr");
      vf->addWidget(pkgRead,0,Qt::AlignLeft);

      vf->addSpacing(100);
    }

    connect( this, SIGNAL(okClicked()), SLOT(apply_slot()) );
    connect( this, SIGNAL(closeClicked()), SLOT(cancel_slot()) );
    connect( this, SIGNAL(cancelClicked()), SLOT(cancel_slot()) );

    setValues();

}


void Options::insHosts() {
  //  kDebug() << "insHosts " <<  "\n";
  bool found = false;
  QString s = hosts->currentText();

  int i;
  for (i = 0; i < hosts->count(); i++) {
    if (s == hosts->itemText(i))
      found = true;
  }

  if (!found)
    hosts->insertItem(0, hosts->currentText());
}

void Options::setValues() {
  //  kDebug() << "setValues:\n";
  DCache = dc = opts->DCache;
  PCache = pc = opts->PCache;
  privCmd = prc = opts->privCmd;
  CacheDir = opts->CacheDir;

  hosts->clear();
  hosts->completionObject()->clear();

  hosts->insertItems(0, opts->hostList);
  if (hosts->completionObject()) {
    hosts->completionObject()->setItems(opts->hostList);
  }

  if (!hostName.isEmpty()) {
    huse->setChecked(true);
  }
  //  kDebug() << "C=" <<opts->hostList.count() << "\n";

  scanLocates();

  dcache[DCache]->setChecked(true);
  pcache[PCache]->setChecked(true);
  privs[privCmd]->setChecked(true);
  cachedir->lineEdit()->setText(CacheDir);

  valid->setChecked(opts->VerifyFL);
  pkgRead->setChecked(opts->PkgRead);
}

Options::~Options()
{
}

void Options::scanLocates() {
  bool remote = huse->isChecked();
     //      kDebug() << i << " " << hostName << " " << kpinterface[i]->hasRemote << "\n";
//      if (kpinterface->hasProgram) {
//	  packageBox->setEnabled(true);
//	if (remote) {
//	  if (kpinterface->hasRemote) {
//	    packageHandle->setEnabled(true);
//	    locate->setEnabled(true);
//	  } else {
//	    packageHandle->setEnabled(false);
//	    locate->setEnabled(false);
//	  }
//	} else {
//	  packageHandle->setEnabled(true);
//	  if ( packageHandle->isChecked()) {
//	    locate->setEnabled(true);
//	  } else {
//	    locate->setEnabled(false);
//	  }
//	}
//      } else {
	packageBox->setEnabled(false);
//      }
}

void Options::useRemote()
{
  scanLocates();
}

void Options::restore()
{
  show();
  fRemote = huse->isChecked();
}

void Options::cancel_slot()
{
  //  kDebug() << "Cancel\n";
  opts->readSettings();
  setValues();
}

void Options::apply_slot()
{
  bool doReload = false;
  bool newHost  = false;

  opts->VerifyFL = valid->isChecked();
  opts->PkgRead = pkgRead->isChecked();

  insHosts();
  opts->hostList.clear();
  int i;
  QString prev;
  for (i = 0; i < hosts->count(); i++) {
    //    kDebug() << "=" << prev << "=" << hosts->text(i) << "=\n";
    QString host = hosts->itemText(i);
    if (prev != host)
      opts->hostList.append(host);
    prev = host;
  }

  QString remoteHost = hosts->currentText();

  if ((fRemote != huse->isChecked()) || huse->isChecked() && (remoteHost != hostName)) {
    newHost = true;
    doReload = true;
  }
  if (huse->isChecked()) {
    hostName = remoteHost;
  } else {
    hostName = "";
  }
  kpkg->setCaption(hostName);

  opts->DCache = dc;
  opts->PCache = pc;
  opts->privCmd = prc;
  cachedir->lineEdit()->setText (QDir(cachedir->lineEdit()->text()).path().append("/")) ; // make sure that cache directory ends with "/"
  opts->CacheDir = cachedir->lineEdit()->text() ;

 
  if (kpackage->findialog)
    kpackage->findialog->checkSearchAll();
  scanLocates();
  opts->writeSettings();

  if (doReload) {
    if (newHost) {
      kpty->close();
    }
    kpackage->reload();
  }
}

void Options::PDCache(int r)
{
  dc = r;
}

void Options::PPCache(int r)
{
  pc = r;
}

void Options::PPrivs(int r)
{
  kDebug() << "Privs=" << r << "\n";
  prc = r;
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

Opts::Opts(const QString &initHost)
{
    readSettings(initHost);
}

Opts::~Opts()
{
}

void Opts::readSettings(const QString &initHost)
{
  KConfigGroup config(KGlobal::config(), "Kpackage");

  //  kDebug() << "readSettings: " << initHost << "\n";
  hostList = config.readEntry("Host_list",QStringList());
  if (!initHost.isEmpty() && !hostList.contains(initHost)) {
    hostList.prepend(initHost);
    config.writeEntry("Host_list", hostList);
  }
  hostList.sort();

  DCache = config.readEntry("Dir_Cache",1);
  if (DCache >2) {
    DCache = 1;
  }
  PCache = config.readEntry("Package_Cache",0);
  if (PCache >2) {
    PCache = 0;
  }
  CacheDir = config.readPathEntry("Cache_Directory", QDir::homePath() + "/.kpackage/");

  // Backward compatability
  bool useSSH = config.readEntry("Use_SSH",0);
  privCmd = config.readEntry("Priv_Command", -1);

  if (privCmd == -1) {
    if (useSSH) {
      privCmd = SSHcmd;
    } else {
      privCmd = SUcmd;
    }
  }
  VerifyFL = config.readEntry("Verify_File_List",1);
  PkgRead = config.readEntry("Read_Package_files",0);
}

void Opts::readLaterSettings()
{
    KConfigGroup config(KGlobal::config(), "Kpackage");

}

void Opts::writeSettings()
{

  KConfigGroup config(KGlobal::config(), "Kpackage");

  config.writeEntry("Host_list", hostList);

  config.writeEntry("Dir_Cache", DCache);
  config.writeEntry("Package_Cache", PCache);
  config.writePathEntry("Cache_Directory", CacheDir);

  config.writeEntry("Priv_Command",privCmd );

  config.writeEntry("Verify_File_List",VerifyFL );
  config.writeEntry("Read_Package_files", PkgRead);

 }

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#include "options.moc"
