/* This file is part of the KDE project
 * Copyright (C) 2007 Montel Laurent <montel@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#define STRIGI_IMPORT_API
#include <strigi/streamthroughanalyzer.h>
#include <strigi/analyzerplugin.h>
#include <strigi/fieldtypes.h>
#include <strigi/analysisresult.h>

//kde include
#include <KUrl>
#include <kdebug.h>
#include <kio/global.h>

//qt include
#include <QFile>
#include <QTextStream>
#include <QRegExp>
#include <qfileinfo.h>
#include <qdir.h>
using namespace std;
using namespace Strigi;

class folderThroughAnalyzerFactory;
class folderThroughAnalyzer : public StreamThroughAnalyzer {
    private:
        const folderThroughAnalyzerFactory* factory;
        AnalysisResult* idx;

        void setIndexable( AnalysisResult *i ) {
            idx = i;
        }
        const char* name() const {
           return "folderThroughAnalyzer";
        }

	InputStream* connectInputStream( InputStream *in );
        bool isReadyWithStream() { return true; }
    public:
        folderThroughAnalyzer( const folderThroughAnalyzerFactory* f ) : factory( f ) {}
};

class folderThroughAnalyzerFactory : public StreamThroughAnalyzerFactory {
private:
    const char* name() const {
        return "folderThroughAnalyzer";
    }
    StreamThroughAnalyzer* newInstance() const {
        return new folderThroughAnalyzer(this);
    }
    void registerFields( FieldRegister& );

    static const std::string itemName;
    static const std::string sizeName;
public:
    const RegisteredField* itemNameField;
    const RegisteredField* sizeNameField;
};

const std::string folderThroughAnalyzerFactory::itemName( "TODO_item" );
const std::string folderThroughAnalyzerFactory::sizeName( "TODO_size" );

void folderThroughAnalyzerFactory::registerFields( FieldRegister& reg ) {
    itemNameField = reg.registerField(itemName, FieldRegister::integerType, 1, 0 );
    sizeNameField = reg.registerField(sizeName, FieldRegister::stringType, 1, 0 );
}
#include <iostream.h>
InputStream* folderThroughAnalyzer::connectInputStream( InputStream* in ) {
    const string& path = idx->path();
    QDir dir;
    std::cout<<"dddddddddddddddddddddd\n";
    if ( !dir.cd(path.c_str()) )
        return in;

    QFileInfoList fileList = dir.entryInfoList();
    if (fileList.isEmpty())
        return in;
    std::cout<<"sssssssssssssssssssss\n";

    int items = 0;
    KIO::filesize_t bytes = 0;
    for (int i = 0; i < fileList.size(); ++i) {
        QFileInfo fileInfo = fileList.at(i);
        if (!fileInfo.fileName().startsWith(".")) {
            items++;
            bytes += fileInfo.size();
        }
    }

    idx->addValue( factory->itemNameField, items );
    idx->addValue( factory->sizeNameField, (const char*)KIO::convertSize(bytes).toUtf8() );
    return in;
}

class Factory : public AnalyzerFactoryFactory {
public:
    std::list<StreamThroughAnalyzerFactory*>
    streamThroughAnalyzerFactories() const {
        std::list<StreamThroughAnalyzerFactory*> af;
        af.push_back(new folderThroughAnalyzerFactory());
        return af;
    }
};

STRIGI_ANALYZER_FACTORY(Factory)

