#!/usr/bin/env python

# Qt tutorial 7.

import sys
import qt


class LCDRange(qt.QVBox):
    def __init__(self, parent=None, name=None):
        qt.QVBox.__init__(self, parent, name)

        lcd = qt.QLCDNumber(2, self, "lcd")
        self.slider = qt.QSlider(qt.Qt.Horizontal, self, "slider")
        self.slider.setRange(0, 99)
        self.slider.setValue(0)
        self.connect(self.slider, qt.SIGNAL("valueChanged(int)"), lcd, qt.SLOT("display(int)"))
        self.connect(self.slider, qt.SIGNAL("valueChanged(int)"), self, qt.PYSIGNAL("valueChanged(int)"))

    def value(self):
        return self.slider.value()

    def setValue(self, value):
        self.slider.setValue(value)


class MyWidget(qt.QVBox):
    def __init__(self, parent=None, name=None):
        qt.QVBox.__init__(self, parent, name)

        quit = qt.QPushButton("Quit", self, "quit")
        quit.setFont(qt.QFont("Times", 18, qt.QFont.Bold))

        self.connect(quit, qt.SIGNAL("clicked()"), qt.qApp, qt.SLOT("quit()"))

        grid = qt.QGrid(4, self)

        self.lcdlist = []
        previous = None

        for r in range(4):
            for c in range(4):
                lr = LCDRange(grid)

                if previous:
                    self.connect(lr, qt.PYSIGNAL("valueChanged(int)"), previous.setValue)

                previous = lr
                self.lcdlist.append(lr)


a = qt.QApplication(sys.argv)

w = MyWidget()
a.setMainWidget(w)
w.show()
sys.exit(a.exec_loop())
