"""
This template constructs an application with menus, toolbar and statusbar,
HOWEVER it is not recommended this template actually be used. It presents
the "KDE 1.0" method for constructing menus and toolbars - later versions
of KDE have introduced better (easier and more powerful) methods for
doing this job - see other menuapp*.py templates for these methods
"""

"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""


False = 0
True  = not False


import sys

from qt import QPopupMenu, SIGNAL

from kdecore import KApplication, KCmdLineArgs, KAboutData, i18n, KStdAccel, KIcon, KIconLoader
from kdeui import KMainWindow, KMessageBox

TOOLBAR_NEW   = 1
TOOLBAR_OPEN  = 2
TOOLBAR_SAVE  = 3
TOOLBAR_CUT   = 4
TOOLBAR_COPY  = 5
TOOLBAR_PASTE = 6

STATUSBAR_LEFT   = 1
STATUSBAR_MIDDLE = 2
STATUSBAR_RIGHT  = 3

class MainWin (KMainWindow):
    def __init__ (self, *args):
        apply (KMainWindow.__init__, (self,) + args)

        self.initMenus ()
        self.initToolBar ()
        self.initStatusBar ()

    def initMenus (self):
        fileMenu = QPopupMenu (self)

        # "File" menu items
        fileMenu.insertItem (i18n ("New"), self.slotNew, KStdAccel.openNew ().keyCodeQt ())
        fileMenu.insertItem (i18n ("Open"), self.slotOpen, KStdAccel.open ().keyCodeQt ())
        fileMenu.insertSeparator ();
        fileMenu.insertItem (i18n ("Save"), self.slotSave, KStdAccel.save ().keyCodeQt ())
        fileMenu.insertItem (i18n ("SaveAs"), self.slotSaveAs)
        fileMenu.insertSeparator ();
        fileMenu.insertItem (i18n ("Print"), self.slotPrint, KStdAccel.print_ ().keyCodeQt ())
        fileMenu.insertSeparator ();
        fileMenu.insertItem (i18n ("&Quit"), self.slotQuit, KStdAccel.quit ().keyCodeQt ());

        self.menuBar ().insertItem (i18n ("&File"), fileMenu)

        editMenu = QPopupMenu (self)

        # "Edit" menu items
        editMenu.insertItem (i18n ("Undo"), self.slotUndo, KStdAccel.undo ().keyCodeQt ())
        editMenu.insertItem (i18n ("Redo"), self.slotRedo, KStdAccel.redo ().keyCodeQt ())
        editMenu.insertSeparator ();
        editMenu.insertItem (i18n ("Cut"), self.slotCut, KStdAccel.cut ().keyCodeQt ())
        editMenu.insertItem (i18n ("Copy"), self.slotCopy, KStdAccel.copy ().keyCodeQt ())
        editMenu.insertItem (i18n ("Paste"), self.slotPaste, KStdAccel.paste ().keyCodeQt ())
        editMenu.insertSeparator ();
        editMenu.insertItem (i18n ("Find"), self.slotFind, KStdAccel.find ().keyCodeQt ())
        editMenu.insertItem (i18n ("Find Next"), self.slotFindNext, KStdAccel.findNext ().keyCodeQt ())
        editMenu.insertItem (i18n ("Replace"), self.slotReplace, KStdAccel.replace ().keyCodeQt ())

        self.menuBar ().insertItem (i18n ("&Edit"), editMenu)

        helpMenu = self.helpMenu ("")
        self.menuBar ().insertItem (i18n ("&Help"), helpMenu)

    def initToolBar (self):
        icons = KIconLoader ()

        self.toolBar ().insertButton (icons.loadIcon ("filenew", KIcon.Toolbar), TOOLBAR_NEW, SIGNAL ("clicked (int)"), self.slotNew,\
                                                       True, "New")
        self.toolBar ().insertButton (icons.loadIcon ("fileopen", KIcon.Toolbar), TOOLBAR_OPEN, SIGNAL ("clicked (int)"), self.slotOpen,\
                                                       True, "Open")
        self.toolBar ().insertButton (icons.loadIcon ("filesave", KIcon.Toolbar), TOOLBAR_SAVE, SIGNAL ("clicked (int)"), self.slotSave,\
                                                       True, "Save")
        self.toolBar ().insertButton (icons.loadIcon ("editcut", KIcon.Toolbar), TOOLBAR_CUT, SIGNAL ("clicked (int)"), self.slotCut,\
                                                       True, "Cut")
        self.toolBar ().insertButton (icons.loadIcon ("editcopy", KIcon.Toolbar), TOOLBAR_COPY, SIGNAL ("clicked (int)"), self.slotCopy,\
                                                       True, "Copy")
        self.toolBar ().insertButton (icons.loadIcon ("editpaste", KIcon.Toolbar), TOOLBAR_PASTE, SIGNAL ("clicked (int)"), self.slotPaste,\
                                                       True, "Paste")

    def initStatusBar (self):
        self.statusBar ().insertItem ("", STATUSBAR_LEFT, 1000, True)
        self.statusBar ().insertItem ("", STATUSBAR_MIDDLE, 1000, True)
        self.statusBar ().insertItem ("", STATUSBAR_RIGHT, 1000, True)


#-------------------- slots -----------------------------------------------

    def slotNew (self, id = -1):
        self.notImpl ("New")

    def slotOpen(self, id = -1):
        self.notImpl ("Open")

    def slotSave (self, id = -1):
        self.notImpl ("Save")

    def slotSaveAs (self):
        self.notImpl ("Save As")

    def slotPrint (self):
        self.notImpl ("Print")

    def slotQuit (self):
        self.notImpl ("Quit")

    def slotUndo (self):
        self.notImpl ("Undo")

    def slotRedo (self):
        self.notImpl ("Redo")

    def slotCut (self, id = -1):
        self.notImpl ("Cut")

    def slotCopy (self, id = -1):
        self.notImpl ("Copy")

    def slotPaste (self, id = -1):
        self.notImpl ("Paste")

    def slotFind (self):
        self.notImpl ("Find")

    def slotFindNext (self):
        self.notImpl ("Find Next")

    def slotReplace (self):
        self.notImpl ("Replace")

    def notImpl (self, item = "Feature"):
        self.statusBar ().changeItem ("%s not implemented" % item, STATUSBAR_LEFT)
        KMessageBox.error (self, "%s not implemented" % item, "Not Implemented")
        self.statusBar ().changeItem ("", STATUSBAR_LEFT)


#-------------------- main ------------------------------------------------

description = "A basic application template"
version     = "1.0"
aboutData   = KAboutData ("", "",\
    version, description, KAboutData.License_GPL,\
    "(C) 2003 whoever the author is")

aboutData.addAuthor ("author1", "whatever they did", "email@somedomain")
aboutData.addAuthor ("author2", "they did something else", "another@email.address")

KCmdLineArgs.init (sys.argv, aboutData)

KCmdLineArgs.addCmdLineOptions ([("+files", "File to open")])

app = KApplication ()
mainWindow = MainWin (None, "main window")
mainWindow.show()
app.exec_loop()
