iconName = 'go'
labelText = 'KProgressDialog'


from qt import QFrame, QHBoxLayout, QVBoxLayout, QTimer, SIGNAL
from kdecore import i18n
from kdeui import KPushButton, KProgressDialog, KTextEdit


helpText = """KDE provides a ready-built dialog to display a bit of text and a 
progress bar."""


class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Progress Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = QHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showProgressDialog)

    def showProgressDialog(self):
        self.dlg = dlg = KProgressDialog(self, None, 'Sample Progress Dialog', 
                                         helpText)
        dlg.progressBar().setTotalSteps(20)
        dlg.progressBar().setFormat('% complete: %p - value: %v - maximum: %m')
        timer = QTimer(self)
        self.connect(timer, SIGNAL('timeout()'), self.updateProgress)
        timer.start(250, False)
        dlg.exec_loop()
        timer.stop()

    def updateProgress(self):
        self.dlg.progressBar().advance(1)
