/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "kdbus.h"

#include <kmainwindow.h>
#include <kstatusbar.h>
#include <kstdaction.h>
#include <kactionclasses.h>
#include <kstdaccel.h>
#include <kapplication.h>
#include <klocale.h>
#include <kdebug.h>
#include <ktabwidget.h>
#include <stdexcept>

#include "dbus/qdbusconnection.h"
#include "dbustreewidget.h"

class kdbus::Private {
public:
    /**
     * Initialise GUI components.
     */
    void initGUI();

    /// Tab widget.
    KTabWidget * tabwidget;

    bool autoReload;

    kdbus * p;
};

kdbus::kdbus()
    : KMainWindow( 0, "kdbus" ), d( new kdbus::Private() )
{
    d->p = this;
    d->autoReload = true;
    d->initGUI();
}

void kdbus::Private::initGUI()
{

    KStdAction::quit(
      KApplication::kApplication(),
      SLOT(closeAllWindows()),
      p->actionCollection()
    );

    __attribute__((unused)) KAction * refresh = new KAction(
      i18n("&Refresh"),
      "reload_page",
      KStdAccel::reload(),
      p,
      SLOT(reload()),
      p->actionCollection(),
      "reload"
    );

    KToggleAction * toggleRefresh = new KToggleAction(
      i18n("Automatically update available services"),
      KShortcut(),
      p,
      SLOT(toggleReload()),
      p->actionCollection(),
      "toggle_auto_reload"
    );
    toggleRefresh->setChecked( autoReload );

    p->setupGUI();
    tabwidget = new KTabWidget( p );

    tabwidget->insertTab(
      new DBusTreeWidget( p, QDBusConnection::SystemBus ),
      i18n( "System Bus" )
    );

    tabwidget->insertTab(
      new DBusTreeWidget( p, QDBusConnection::SessionBus ),
      i18n( "Session Bus" )
    );

    p->setCentralWidget( tabwidget );
    
}

void kdbus::toggleReload() {
    if ( d->autoReload )
        d->autoReload = false;
    else
        d->autoReload = true;
}

void kdbus::reload() {
    QWidget * widget = d->tabwidget->currentPage();
    if ( !widget )
        throw std::logic_error("Not displaying any tab!");
        
    if ( !dynamic_cast< DBusTreeWidget * >( widget ) )
        throw std::logic_error("Have a tab which isn't DBusTreeWidget!");

    dynamic_cast< DBusTreeWidget * >( widget )->reload();
}

bool kdbus::reloadOnServiceChange() const {
    return d->autoReload;
}

kdbus::~kdbus() {
    delete d;
}

#include "kdbus.moc"
