/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DBUSMETHOD_H
#define DBUSMETHOD_H

#include <qptrlist.h>

#include "dbusexceptions.h"
#include "dbusmethodorsignal.h"

class KLineEdit;
class QTextEdit;

/**
 * Representation of a D-BUS method
 */
class DBusMethod : public DBusMethodOrSignal {
    public:
        /**
         * @param parent parent QListViewItem
         * @param elem  QDomElement representing this method as returned
         *              by org.freedesktop.DBus.Introspectable.Introspect.
         */
        DBusMethod(
          QListViewItem * parent,
          QDomElement const & elem
        ) throw( QDBusXmlError );

        ~DBusMethod();

        /**
         * @see DBusItem::widget
         */
        QWidget * widget( QWidget * parent ) const;

        /**
         * @returns input boxes
         */
        QPtrList< KLineEdit > inputBoxes() const;

        /**
         * @returns output boxes
         */
        QPtrList< QTextEdit > outputBoxes() const;

        /**
         * @returns input arguments
         */
        QPtrList< DBusMethodArgument > inArgs() const;

        /**
         * @returns output arguments
         */
        QPtrList< DBusMethodArgument > outArgs() const;

    private:
        class Private; Private * d;

        /// Not implemented.
        DBusMethod( DBusMethod const & other );

        /// Not implemented.
        const DBusMethod & operator=( DBusMethod const & other );
};

#endif
