/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "dbusitem.h"

#include "dbusservice.h"
#include "dbusobject.h"
#include "dbusinterface.h"

#include <qstring.h>
#include <qvbox.h>
#include <qlabel.h>
#include <klocale.h>
#include <stdexcept>

DBusItem::DBusItem(
  QListViewItem * parent,
  QString const & text1,
  QString const & text2
) : QListViewItem( parent, text1, text2 ),
    m_ok(true)
{
}


DBusItem::DBusItem(
  QListView * parent,
  QString const & text1,
  QString const & text2
) : QListViewItem( parent, text1, text2 ),
    m_ok(true)
{
}


QString DBusItem::service() const {
    return m_service;
}

QString DBusItem::object() const {
    return m_object;
}

QString DBusItem::interface() const {
    return m_interface;
}

QString DBusItem::discoverService() const {
    if ( dynamic_cast< DBusService const * const >(this) )
        throw std::logic_error(
           "DBusService should not call discoverService"
        );

    QListViewItem * parent = this->parent();
    if ( dynamic_cast< DBusItem * >(parent) )
        return dynamic_cast< DBusItem * >(parent)->service();

    throw std::logic_error(
      "DBusItem can't find its service!"
    );
}

QString DBusItem::discoverInterface() const {
    if ( dynamic_cast< DBusService const * const >(this) )
        throw std::logic_error(
           "DBusInterface should not call discoverInterface"
        );

    QListViewItem * parent = this->parent();
    if ( dynamic_cast< DBusItem * >(parent) )
        return dynamic_cast< DBusItem * >(parent)->interface();

    throw std::logic_error(
      "DBusItem can't find its interface!"
    );
}

QString DBusItem::discoverObject() const {

    if ( dynamic_cast< DBusService const * const >(this) )
        throw std::logic_error(
           "DBusObject should not call discoverObject"
        );

    QListViewItem * parent = this->parent();
    if ( dynamic_cast< DBusItem * >(parent) )
        return dynamic_cast< DBusItem * >(parent)->object();

    throw std::logic_error(
      "DBusItem can't find its object!"
    );
}


void DBusItem::addErrorInfo( QWidget * widget ) const {
    if ( m_ok )
        return;

    QVBox * vbox = new QVBox( widget );
    new QLabel( vbox );
    new QLabel( i18n( "<b>Error:</b>" ), vbox );
    new QLabel(
      i18n(
        "The following error occurred while inspecting this item: %1"
      ).arg( m_error ),
      vbox
    );
    new QLabel(
      i18n(
        "As a result, some or all of the information regarding this item "
        "may be unavailable."
      ),
      vbox
    );


}

void DBusItem::ensureElementIsNamed(
  QDomElement const & elem,
  QString const & name
) throw( std::logic_error ) {
    if ( elem.tagName() != name )
        throw std::logic_error(
          QString(
            "Created a DBusItem with tag '%1' instead of required tag '%2'"
          ).arg( elem.tagName() ).arg( name )
        );
}

void DBusItem::ensureElementHasAttribute(
  QDomElement const & elem,
  QString const & attr
) throw( QDBusXmlError ) {
    if ( !elem.hasAttribute( attr ) )
        throw QDBusXmlError(
          i18n(
            "'tag' means XML tag, 'attribute' means XML attribute",
            "Found tag '%1' without required attribute '%2'"
          ).arg( elem.tagName() ).arg( attr )
        );
}


DBusItem::~DBusItem() {
}
