/***************************************************************************
 *   Copyright (C) 2006 by Rohan McGovern                                  *
 *   rohan.pm@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DBUSINTERFACE_H
#define DBUSINTERFACE_H

#include "dbusexceptions.h"
#include "dbusannotatable.h"

/**
 * Representation of a D-BUS interface.
 */
class DBusInterface
 : public DBusAnnotatable
{
    public:
        /**
         * @param parent parent QListViewItem
         * @param elem  QDomElement representing this interface as returned
         *              by org.freedesktop.DBus.Introspectable.Introspect.
         */
        DBusInterface(
          QListViewItem * parent,
          QDomElement const & elem
        ) throw( QDBusXmlError );

        /**
         * @see DBusItem::widget
         */
        QWidget * widget( QWidget * parent ) const;

    private:
        /// Not implemented.
        DBusInterface( DBusInterface const & other );

        /// Not implemented.
        const DBusInterface & operator=( DBusInterface const & other );
};

#endif
