/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _POPULATETREEARCHIVETHREAD_H_
#define _POPULATETREEARCHIVETHREAD_H_

#include "kdarthread.h"

class QListViewItem;

/**
 * This is the populateTreeArchiveThread class.
 * It runs libdar::get_children_of() on @ref directory to fill-in the contents.
 *
 * @short Thread for populating the contents of the archive browser.
 * @author Johnathan K. Burchill, jkerrb@users.sourceforge.net
 * @version 1.3.0
 */
class populateTreeArchiveThread : public KDarThread {

public:
    /**
     * Constructor
     * @param aController the controller responsible for deleting the thread.
     * @param directory the current directory that is to be populated.
     */
    populateTreeArchiveThread( controller * aController, QListViewItem * directory );
    ~populateTreeArchiveThread();

    void run();

private:
    QListViewItem *m_directory;
};
#endif // _POPULATETREEARCHIVETHREAD_H_
