/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kdartestsdialog.h"
#include "kdar.h"
#include "kdarcontroller.h"

#include "kdarEnums.h"
#include "kdarConfig.h"

#include <kapp.h>
#include <kdebug.h>
#include <klineedit.h>

#include <qlistview.h>
#include <qstring.h>
#include <qwidgetstack.h>

#include <fnmatch.h>

KDarTestsDialog::KDarTestsDialog(QWidget* parent, const char* name, WFlags fl)
        : KDarTestsDlg(parent,name,fl)
{
        kdarWidget = new kdar( new KDarController );
//        kdarWidget->m_view->m_createConfig->setDifferentialBackupArchiveName( "test-reference" );

        //Test fnmatch function:
//        char *tmp0 = "/opt/user/src/kdarcvs/kdar/";
//        char *tmp1 = "/opt/user/src/kdarcvs/kdar/admin";
//        char *tmp2 = "/opt/user/src/kdarcvs/kdar/admin/";
//        char *tmp3 = "/opt/user/src/kdarcvs/kdar/admin/test.txt";
//        char *tmp4 = "/opt/user/src/kdarcvs/kdar/admin/src/";
//        char *tmp5 = "/opt/user/src/kdarcvs/kdar/admin/src/testsrc.txt";

//        char *the_mask = "/opt/user/src/kdarcvs/kdar/admin/";
//        bool ret0, ret1, ret2, ret3, ret4, ret5;

//        ret0 = fnmatch(the_mask, tmp0, FNM_PERIOD) == 0;
//        ret1 = fnmatch(the_mask, tmp1, FNM_PERIOD) == 0;
//        ret2 = fnmatch(the_mask, tmp2, FNM_PERIOD) == 0;
//        ret3 = fnmatch(the_mask, tmp3, FNM_PERIOD) == 0;
//        ret4 = fnmatch(the_mask, tmp4, FNM_PERIOD) == 0;
//        ret5 = fnmatch(the_mask, tmp5, FNM_PERIOD) == 0;

//      std::cout << "ret0: " << ret0 << std::endl;
//      std::cout << "ret1: " << ret1 << std::endl;
//      std::cout << "ret2: " << ret2 << std::endl;
//      std::cout << "ret3: " << ret3 << std::endl;
//      std::cout << "ret4: " << ret4 << std::endl;
//      std::cout << "ret5: " << ret5 << std::endl;
}

KDarTestsDialog::~KDarTestsDialog()
{}

/*$SPECIALIZATION$*/

void KDarTestsDialog::quit()
{
        kapp->quit();
}
void KDarTestsDialog::slotRaiseWidgetStack( QListViewItem * item )
{
        if ( item )
        {
                QString module = item->text( 0 );
                if ( module == "GUI" )
                {
                        testWidgetStack->raiseWidget( KDar::GUI );
                }
                else if ( module == "Libdar operations" )
                {
                        testWidgetStack->raiseWidget( KDar::LIBDAROPERATIONS );
                }
                else if ( module == "String substitution" )
                {
                        testWidgetStack->raiseWidget( KDar::STRINGSUBSTITUTION );
                }
                else if ( module == "Archive handle" )
                {
                        testWidgetStack->raiseWidget( KDar::ARCHIVEHANDLE );
                }
                else
                {
                        kdDebug() << "KDarTestsDialog::slotRaiseWidgetStack(): " << module << ": no such test module." << endl;
                }
        }
}

void KDarTestsDialog::slotTestStringSubstitutionNewArchiveName( const QString & name )
{
        //Test the string substitution code in kdar
        QString result( name );
        //QString result = kdarWidget->m_view->parseStringSubstitutions( name );
        archiveNameResultKLineEdit->setText( result );
}


#include "kdartestsdialog.moc"

