/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KDARPROGRESSDIALOG_H
#define KDARPROGRESSDIALOG_H

#include "kdarProgressDlg.h"

#include <qstring.h>

/**
 * This is a progress dialog class. Use this to show the user some information
 * on the progress of the archive creation in a window.
 */
class kdarProgressDialog : public kdarProgressDlg
{
    Q_OBJECT

public:
    /**
     * Constructor.
     */
    kdarProgressDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    /**
     * Destructor.
     */
    virtual ~kdarProgressDialog();
    /*$PUBLIC_FUNCTIONS$*/

signals:
    /*$PUBLIC_SIGNALS$*/
    /**
     * Signal the view that the user wants to cancel the operation.
     */
    virtual void userCancelled();

public slots:
    /*$PUBLIC_SLOTS$*/
    /**
     * This is called if the user hits the cancel button.
     */
    virtual void cancelOperation();
    /**
     * Set the slice information label's text
     */
    virtual void setSliceInfo( const QString & );
    /**
     * Set the media label's text
     */
    virtual void setMediaInfo( const QString & );
    /**
     * Set the file info text
     */
    virtual void setFileInfo( const QString & );
    /**
     * Set the file extra-info text
     */
    virtual void setFileExtraInfo( const QString & );
    /**
     * Set the elapsed-time label's text
     */
    virtual void setElapsedTime( const QString & );
    /**
     * Update the progress bar's reading
     */
    virtual void updateProgressBar( const int percentage );
    /**
     * Set the progress dialog's caption
     */
    virtual void updateCaption( const QString & );

protected:
    /*$PROTECTED_FUNCTIONS$*/

protected slots:
    /*$PROTECTED_SLOTS$*/

};

#endif

