/***************************************************************************
 *   Copyright (C) 2004, 2005 by Johnathan Burchill                              *
 *   jkerrb@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/


#include "kdarprogressdialog.h"

#include <kdebug.h>
#include <kmessagebox.h>
#include <kprogress.h>
#include <ksqueezedtextlabel.h>

#include <qlabel.h>
#include <qstring.h>

#include <iostream>

kdarProgressDialog::kdarProgressDialog(QWidget* parent, const char* name, bool modal, WFlags fl)
        : kdarProgressDlg(parent,name, modal,fl)
{
    filesProcessedKProgress->setTotalSteps( 100 );
}

kdarProgressDialog::~kdarProgressDialog()
{}

/*$SPECIALIZATION$*/
void kdarProgressDialog::cancelOperation()
{
    emit userCancelled();
}

void kdarProgressDialog::setSliceInfo( const QString & sliceInfo )
{
    sliceInfoTextLabel->setText( sliceInfo );
}

void kdarProgressDialog::setMediaInfo( const QString & mediaInfo )
{
    mediaTypeTextLabel->setText( mediaInfo );
}

void kdarProgressDialog::setFileInfo( const QString & message )
{
    currentFileKSqueezedTextLabel->setText( message );
}

void kdarProgressDialog::setFileExtraInfo( const QString & message )
{
    extraFileInfoKSqueezedTextLabel->setText( message );
}

void kdarProgressDialog::setElapsedTime( const QString & elapsedTime )
{
    elapsedTimeTextLabel->setText( elapsedTime );
}

void kdarProgressDialog::updateProgressBar( const int percentage )
{
    filesProcessedKProgress->setProgress( percentage );
}

void kdarProgressDialog::updateCaption( const QString & text )
{
    setCaption( text );
}

#include "kdarprogressdialog.moc"
